/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.encoding.binary;

public class LittleEndianByteUtils {
    public static int bytesToInt(byte[] byArray) {
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
    }

    public static long bytesToLong(byte[] byArray) {
        return (long)(byArray[0] & 0xFF) | ((long)byArray[1] & 0xFFL) << 8 | ((long)byArray[2] & 0xFFL) << 16 | ((long)byArray[3] & 0xFFL) << 24 | ((long)byArray[4] & 0xFFL) << 32 | ((long)byArray[5] & 0xFFL) << 40 | ((long)byArray[6] & 0xFFL) << 48 | (long)byArray[7] << 56;
    }

    public static short bytesToShort(byte[] byArray) {
        return (short)(byArray[0] & 0xFF | byArray[1] << 8);
    }

    public static byte[] intToBytes(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
        return byArray;
    }

    public static byte[] longToBytes(long l2) {
        byte[] byArray = new byte[]{(byte)(l2 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 56 & 0xFFL)};
        return byArray;
    }

    public static byte[] shortToBytes(short s2) {
        byte[] byArray = new byte[]{(byte)(s2 & 0xFF), (byte)(s2 >> 8 & 0xFF)};
        return byArray;
    }

    public static byte[] writeInt(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3] = (byte)(n2 >> 24 & 0xFF);
        return byArray;
    }

    public static byte[] writeLong(long l2, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(l2 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 24 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 32 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 40 & 0xFFL);
        byArray[n2++] = (byte)(l2 >> 48 & 0xFFL);
        byArray[n2] = (byte)(l2 >> 56 & 0xFFL);
        return byArray;
    }

    public static byte[] writeShort(short s2, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(s2 & 0xFF);
        byArray[n2] = (byte)(s2 >> 8 & 0xFF);
        return byArray;
    }

    private LittleEndianByteUtils() {
    }
}

