/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkAsymmDecryptVerifier
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(ChunkAsymmDecryptVerifier.class);
    ByteBuffer xX;
    SecurityConfiguration xY;
    String vu;
    byte[] xZ;
    byte[] ya;

    public ChunkAsymmDecryptVerifier(ByteBuffer byteBuffer, SecurityConfiguration securityConfiguration) {
        this.xX = byteBuffer;
        this.xY = securityConfiguration;
    }

    public byte[] getReceiverCertificateThumbprint() {
        return this.ya;
    }

    public String getSecurityPolicyUri() {
        return this.vu;
    }

    public byte[] getSenderCertificate() {
        return this.xZ;
    }

    @Override
    public void run() throws RuntimeServiceResultException {
        try {
            SecurityPolicy securityPolicy = this.xY.getSecurityPolicy();
            MessageSecurityMode messageSecurityMode = this.xY.getMessageSecurityMode();
            if (messageSecurityMode == MessageSecurityMode.Sign) {
                messageSecurityMode = MessageSecurityMode.SignAndEncrypt;
            }
            this.xX.position(12);
            this.vu = ChunkUtils.getString(this.xX);
            logger.debug("SecurityPolicy in use: {}", (Object)this.vu);
            logger.debug("SecurityMode in use: {}", (Object)this.xY.getMessageSecurityMode());
            if (logger.isTraceEnabled()) {
                logger.trace("Chunk: {}", (Object)CryptoUtil.toHex(this.xX.array(), 64));
            }
            this.xZ = ChunkUtils.getByteString(this.xX);
            this.ya = ChunkUtils.getByteString(this.xX);
            int n2 = this.xX.position();
            int n3 = this.xX.position() + 8;
            int n4 = this.xX.limit();
            int n5 = n4 - n2;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                byte[] byArray = new byte[n5];
                this.xX.position(n2);
                this.xX.get(byArray, 0, byArray.length);
                n5 = this.a(byArray, this.xY.getLocalPrivateKey(), this.xX.array(), n2 + this.xX.arrayOffset());
                if (logger.isTraceEnabled()) {
                    logger.trace("Chunk decrypted: {}", (Object)CryptoUtil.toHex(this.xX.array(), 64));
                }
            }
            int n6 = 0;
            if (MessageSecurityMode.Sign == messageSecurityMode || MessageSecurityMode.SignAndEncrypt == messageSecurityMode) {
                SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
                logger.debug("signatureAlgorithm={}", (Object)securityAlgorithm);
                PublicKey publicKey = this.xY.getRemoteCertificate().getPublicKey();
                n6 = CryptoUtil.getSignatureSize(securityAlgorithm, publicKey);
                logger.debug("signatureSize={}", (Object)n6);
                byte[] byArray = new byte[n2 + n5 - n6];
                this.xX.position(0);
                this.xX.get(byArray, 0, byArray.length);
                this.xX.position(n2 + n5 - n6);
                byte[] byArray2 = new byte[n6];
                this.xX.get(byArray2, 0, n6);
                Certificate certificate = this.xY.getRemoteCertificate();
                if (!this.a(byArray, certificate, byArray2)) {
                    logger.error("Signature verification fails.");
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Signature could not be VERIFIED");
                }
            }
            int n7 = 0;
            if (messageSecurityMode == MessageSecurityMode.SignAndEncrypt) {
                int n8;
                byte by;
                boolean bl;
                int n9 = this.xY.getLocalCertificate2().getCertificate().getKeySize();
                int n10 = n2 + n5 - n6 - 1;
                boolean bl2 = bl = n9 > 2048;
                if (bl) {
                    by = this.xX.get(n10 - 1);
                    n8 = this.xX.get(n10);
                    n7 = (by & 0xFF | (n8 & 0xFF) << 8) + 2;
                } else {
                    by = this.xX.get(n10);
                    n7 = (by & 0xFF) + 1;
                }
                logger.debug("paddingEnd={} paddingSize={}", (Object)n10, (Object)n7);
                n8 = bl ? n7 - 1 : n7;
                int n11 = bl ? n10 - n8 : n10 - n8 + 1;
                for (int i2 = 0; i2 < n8; ++i2) {
                    byte by2 = this.xX.get(n11 + i2);
                    if (by2 == by) continue;
                    logger.error(String.format(Locale.ROOT, "Padding does not match: %x <> %x", (int)by2, (int)by));
                    throw new ServiceResultException(StatusCodes.Bad_SecurityChecksFailed, "Could not verify the padding in the message");
                }
            }
            this.xX.position(n3);
            this.xX.limit(this.xX.position() + n5 - 8 - n7 - n6);
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private int a(byte[] byArray, PrivateKey privateKey, byte[] byArray2, int n2) throws ServiceResultException {
        int n3 = CryptoUtil.getCryptoProvider().decryptAsymm(privateKey, this.xY.getSecurityPolicy().getAsymmetricEncryptionAlgorithm(), byArray, byArray2, n2);
        if (logger.isTraceEnabled()) {
            logger.trace("decrypt: dataToDecrypt={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("decrypt: output={}", (Object)CryptoUtil.toHex(byArray2, 64));
            logger.trace("decrypt: bytesDecrypted={}", (Object)n3);
        }
        return n3;
    }

    private boolean a(byte[] byArray, Certificate certificate, byte[] byArray2) throws ServiceResultException {
        SecurityPolicy securityPolicy = this.xY.getSecurityPolicy();
        logger.debug("verify: policy={}", (Object)securityPolicy);
        if (logger.isTraceEnabled()) {
            logger.trace("verify: {}", (Object)certificate);
            logger.trace("verify: dataToVerify={}", (Object)CryptoUtil.toHex(byArray, 64));
            logger.trace("verify: signature={}", (Object)CryptoUtil.toHex(byArray2, 64));
        }
        return CryptoUtil.getCryptoProvider().verifyAsymm(certificate.getPublicKey(), this.xY.getSecurityPolicy().getAsymmetricSignatureAlgorithm(), byArray, byArray2);
    }
}

