/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.impl;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class ChunkUtils {
    public static byte[] getByteString(ByteBuffer byteBuffer) throws ServiceResultException {
        int n2 = byteBuffer.getInt();
        if (n2 == -1) {
            return null;
        }
        if (n2 < -1 || n2 > byteBuffer.remaining()) {
            throw new ServiceResultException(StatusCodes.Bad_CommunicationError, "Unexpected length");
        }
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static int getMessageType(ByteBuffer byteBuffer) {
        byteBuffer.position(0);
        return byteBuffer.getInt();
    }

    public static int getSecureChannelId(ByteBuffer byteBuffer) {
        byteBuffer.position(8);
        return byteBuffer.getInt();
    }

    public static String getSecurityPolicyUri(ByteBuffer byteBuffer) throws ServiceResultException {
        byteBuffer.position(12);
        return ChunkUtils.getString(byteBuffer);
    }

    public static String getString(ByteBuffer byteBuffer) throws ServiceResultException {
        byte[] byArray = ChunkUtils.getByteString(byteBuffer);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public static int getTokenId(ByteBuffer byteBuffer) {
        byteBuffer.position(12);
        return byteBuffer.getInt();
    }

    private ChunkUtils() {
    }
}

