/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.io;

import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ChannelSecurityToken;
import com.prosysopc.ua.stack.core.CloseSecureChannelRequest;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.OpenSecureChannelRequest;
import com.prosysopc.ua.stack.core.OpenSecureChannelResponse;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.IConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseTransportChannelSettings;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.impl.AbstractUaTcpCommMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Acknowledge;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkFactory;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmEncryptSigner;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.ErrorMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.Hello;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalClientSideDecodingServiceFault;
import com.prosysopc.ua.stack.transport.tcp.impl.ReverseHello;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.io.IConnection;
import com.prosysopc.ua.stack.transport.tcp.io.OpcTcpSettings;
import com.prosysopc.ua.stack.transport.tcp.io.SequenceNumber;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnectionLimits;
import com.prosysopc.ua.stack.transport.tcp.io.TcpQuotas;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.TimerUtil;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayWriteable2;
import com.prosysopc.ua.stack.utils.bytebuffer.LittleEndianInputStreamReadable;
import com.prosysopc.ua.stack.utils.bytebuffer.LittleEndianOutputStreamWriteable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpConnection
implements IConnection {
    static Logger logger = LoggerFactory.getLogger(TcpConnection.class);
    private static int yX = 0;
    private static int yY = 60000;
    private static int yZ = 0;
    private static int za = 0;
    private static SocketFactory hm = new DefaultSocketFactory();
    private static ReverseConnectionProvider zb = new DefaultReverseConnectionProvider();
    private static ExecutorProvider zc = new DefaultExecutorProvider();
    EncodeType encodeType;
    PrivKey rx;
    Cert rw;
    Cert rv;
    EndpointConfiguration gw;
    EndpointDescription zd;
    CertificateValidator cH;
    InetSocketAddress addr;
    TcpConnectionLimits ze;
    TcpQuotas zf = TcpQuotas.DEFAULT_CLIENT_QUOTA;
    EnumSet<OpcTcpSettings.Flag> yA = EnumSet.noneOf(OpcTcpSettings.Flag.class);
    int connectTimeout = yY;
    int yB = yY;
    SecurityConfiguration securityConfiguration;
    final List<SecurityToken> zg = new CopyOnWriteArrayList<SecurityToken>();
    final Map<Integer, SecurityToken> zh = new ConcurrentHashMap<Integer, SecurityToken>();
    final Map<Integer, ByteString> zi = new ConcurrentHashMap<Integer, ByteString>();
    final Map<Integer, SequenceNumber> zj = new ConcurrentHashMap<Integer, SequenceNumber>();
    private SocketWrapper zk = null;
    int zl;
    LittleEndianOutputStreamWriteable zm;
    ReentrantLock lock = new ReentrantLock();
    b zn;
    EncoderContext ctx;
    List<IConnection.IMessageListener> listeners = new CopyOnWriteArrayList<IConnection.IMessageListener>();
    List<IConnectionListener> zo = new CopyOnWriteArrayList<IConnectionListener>();
    ReverseConnectionListener hi = null;
    boolean zp = false;
    int yC = yZ;
    private SocketFactory zq;

    public static int getDefaultHandshakeTimeout() {
        return yY;
    }

    public static int getDefaultReverseHelloAcceptTimeout() {
        return yZ;
    }

    public static ExecutorProvider getExecutorProvider() {
        return zc;
    }

    public static int getReceiveBufferSize() {
        return yX;
    }

    public static ReverseConnectionProvider getReverseConnectionProvider() {
        return zb;
    }

    public static int getSendBufferSize() {
        return za;
    }

    public static SocketFactory getSocketFactory() {
        return hm;
    }

    public static void setDefaultHandshakeTimeout(int n2) {
        yY = n2;
    }

    public static void setDefaultReverseHelloAcceptTimeout(int n2) {
        yZ = n2;
    }

    public static void setExecutorProvider(ExecutorProvider executorProvider) {
        zc = executorProvider;
    }

    public static void setReceiveBufferSize(int n2) {
        yX = n2;
    }

    public static void setReverseConnectionProvider(ReverseConnectionProvider reverseConnectionProvider) {
        zb = reverseConnectionProvider;
    }

    public static void setSendBufferSize(int n2) {
        za = n2;
    }

    public static void setSocketFactory(SocketFactory socketFactory) {
        hm = socketFactory;
    }

    @Override
    public void addConnectionListener(IConnectionListener iConnectionListener) {
        this.zo.add(iConnectionListener);
    }

    @Override
    public void addMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.add(iMessageListener);
    }

    @Override
    public void close() {
        b b2 = this.zn;
        if (b2 != null) {
            b2.zA = true;
        }
        this.a(new ServiceResultException(StatusCodes.Bad_CommunicationError, "Socket closed by the user"));
    }

    @Override
    public void dispose() {
        this.lock.lock();
        try {
            this.close();
            this.rx = null;
            this.rw = null;
            this.rv = null;
            this.gw = null;
            this.zd = null;
            this.cH = null;
            this.setSocket(null);
            this.ctx = null;
            this.zm = null;
            this.zf = null;
            this.ze = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.gw;
    }

    public EndpointDescription getEndpointDescription() {
        return this.zd;
    }

    public int getHandshakeTimeout() {
        return this.yB;
    }

    public EncoderContext getMessageContext() {
        return this.ctx;
    }

    public int getProtocolVersion() {
        return this.zl;
    }

    public int getReverseHelloAcceptTimeout() {
        return this.yC;
    }

    public SocketAddress getSocketAddress() {
        return this.addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(InetSocketAddress inetSocketAddress, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.lock.lock();
        try {
            if (transportChannelSettings.getOpctcpSettings().getConnectTimeout() >= 0) {
                this.connectTimeout = transportChannelSettings.getOpctcpSettings().getConnectTimeout();
            }
            if (transportChannelSettings.getOpctcpSettings().getHandshakeTimeout() >= 0) {
                this.yB = transportChannelSettings.getOpctcpSettings().getHandshakeTimeout();
            }
            if (transportChannelSettings.getOpctcpSettings().getReverseHelloAcceptTimeout() >= 0) {
                this.yC = transportChannelSettings.getOpctcpSettings().getReverseHelloAcceptTimeout();
            }
            this.addr = inetSocketAddress;
            if (transportChannelSettings instanceof ReverseTransportChannelSettings) {
                this.hi = ((ReverseTransportChannelSettings)transportChannelSettings).getReverseConnectionListener();
                this.zp = true;
            } else {
                this.hi = null;
                this.zp = false;
                this.zq = transportChannelSettings.getOpctcpSettings().getSocketFactory();
            }
            this.gw = transportChannelSettings.getConfiguration().clone();
            this.zd = transportChannelSettings.getDescription().clone();
            this.cH = transportChannelSettings.getOpctcpSettings().getCertificateValidator();
            this.ctx = encoderContext;
            this.rw = transportChannelSettings.getOpctcpSettings().getClientCertificate();
            this.rv = transportChannelSettings.getServerCertificate();
            this.rx = transportChannelSettings.getOpctcpSettings().getPrivKey();
            this.encodeType = EncodeType.Binary;
            if (this.gw.getUseBinaryEncoding() != null && !this.gw.getUseBinaryEncoding().booleanValue()) {
                this.encodeType = EncodeType.Xml;
            }
            this.yA = transportChannelSettings.getOpctcpSettings().getFlags();
            KeyPair keyPair = this.rw == null ? null : new KeyPair(this.rw, this.rx);
            SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(this.zd.getSecurityPolicyUri());
            SecurityMode securityMode = new SecurityMode(securityPolicy, this.zd.getSecurityMode());
            this.securityConfiguration = new SecurityConfiguration(securityMode, keyPair, this.rv);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initialize(String string, TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        try {
            InetSocketAddress inetSocketAddress = UriUtil.getSocketAddress(string);
            this.initialize(inetSocketAddress, transportChannelSettings, encoderContext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Error while TcpConnection.initialize", (Throwable)illegalArgumentException);
            throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
        }
    }

    public void initialize(TransportChannelSettings transportChannelSettings, EncoderContext encoderContext) throws ServiceResultException {
        this.initialize(transportChannelSettings.getDescription().getEndpointUrl(), transportChannelSettings, encoderContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws ServiceResultException {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper != null && socketWrapper.isConnected()) {
                return;
            }
            if (!this.zp) {
                try {
                    logger.info("{} Connecting", (Object)this.addr);
                    socketWrapper = this.zq != null ? this.zq.createSocket(this) : hm.createSocket(this);
                    socketWrapper.setTcpNoDelay(true);
                    if (yX > 0) {
                        socketWrapper.setReceiveBufferSize(yX);
                    }
                    if (za > 0) {
                        socketWrapper.setSendBufferSize(za);
                    }
                    this.setSocket(socketWrapper);
                    if (this.yB > 0) {
                        socketWrapper.setSoTimeout(this.yB);
                    }
                    if (this.connectTimeout == 0) {
                        socketWrapper.connect(this.addr);
                    } else {
                        socketWrapper.connect(this.addr, this.connectTimeout);
                    }
                }
                catch (ConnectException connectException) {
                    logger.info(this.addr + " Connect failed", (Throwable)connectException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)connectException);
                }
                catch (IOException iOException) {
                    logger.info(this.addr + " Connect failed", (Throwable)iOException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ServiceResultException(StatusCodes.Bad_ServerUriInvalid);
                }
                logger.debug("{} Socket connected", (Object)this.addr);
            } else {
                try {
                    try {
                        socketWrapper = zb.provideOpenReverseConnectionSocket(this);
                    }
                    catch (SocketException socketException) {
                        logger.info("ServerSocket.accept {} failed (or the socket was closed while waiting)", (Object)this.addr, (Object)socketException);
                        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, (Throwable)socketException, "ServerSocket.accept failed (or was closed, possibly due to a timeout)");
                    }
                    socketWrapper.setTcpNoDelay(true);
                    if (yX > 0) {
                        socketWrapper.setReceiveBufferSize(yX);
                    }
                    if (za > 0) {
                        socketWrapper.setSendBufferSize(za);
                    }
                    if (this.yB > 0) {
                        socketWrapper.setSoTimeout(this.yB);
                    }
                    this.setSocket(socketWrapper);
                    logger.debug("{} Socket connected", (Object)socketWrapper.getRemoteSocketAddress());
                }
                catch (IOException iOException) {
                    logger.info(this.addr + " Connect failed", (Throwable)iOException);
                    throw new ServiceResultException(StatusCodes.Bad_ConnectionRejected, (Throwable)iOException);
                }
            }
            try {
                AbstractUaTcpCommMessage abstractUaTcpCommMessage;
                this.eCB();
                LittleEndianOutputStreamWriteable littleEndianOutputStreamWriteable = new LittleEndianOutputStreamWriteable(new BufferedOutputStream(socketWrapper.getOutputStream()));
                LittleEndianInputStreamReadable littleEndianInputStreamReadable = new LittleEndianInputStreamReadable(new BufferedInputStream(socketWrapper.getInputStream()), Long.MAX_VALUE);
                BinaryDecoder binaryDecoder = new BinaryDecoder(this.ctx, littleEndianInputStreamReadable);
                BinaryEncoder binaryEncoder = new BinaryEncoder(this.ctx, littleEndianOutputStreamWriteable);
                if (this.zp) {
                    abstractUaTcpCommMessage = this.a(littleEndianInputStreamReadable, binaryDecoder);
                    logger.debug("Got ReverseHello: {}", (Object)abstractUaTcpCommMessage);
                    if (((ReverseHello)abstractUaTcpCommMessage).getServerUri() == null || ((ReverseHello)abstractUaTcpCommMessage).getServerUri().length() > 4096) {
                        logger.error("ReverseHello did not contain ServerUri, or is too long, got:{}", (Object)((ReverseHello)abstractUaTcpCommMessage).getServerUri());
                        throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                    }
                    if (((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl() == null || ((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl().length() > 4096) {
                        logger.error("ReverseHello did not contain correct EndpointUrl, or is too long, got:{}", (Object)((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl());
                        throw new ServiceResultException(StatusCodes.Bad_TcpEndpointUrlInvalid);
                    }
                    if (this.hi != null && !this.hi.onConnect(((ReverseHello)abstractUaTcpCommMessage).getServerUri(), ((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl(), socketWrapper.getRemoteSocketAddress())) {
                        throw new ServiceResultException(StatusCodes.Bad_ConnectionClosed, "Reverse Connection rejected by the ReverseConnectionListener");
                    }
                    if (this.zd.getEndpointUrl() == null) {
                        this.zd.setEndpointUrl(((ReverseHello)abstractUaTcpCommMessage).getEndpointUrl());
                    }
                }
                abstractUaTcpCommMessage = new Hello();
                ((Hello)abstractUaTcpCommMessage).setEndpointUrl(this.zd.getEndpointUrl());
                ((Hello)abstractUaTcpCommMessage).setMaxChunkCount(UnsignedInteger.valueOf(this.gw.getMaxBufferSize() == null ? 65535L : (long)this.gw.getMaxBufferSize().intValue()));
                ((Hello)abstractUaTcpCommMessage).setMaxMessageSize(UnsignedInteger.valueOf(this.ctx.getMaxMessageSize()));
                ((Hello)abstractUaTcpCommMessage).setReceiveBufferSize(UnsignedInteger.valueOf(this.zf.maxBufferSize));
                ((Hello)abstractUaTcpCommMessage).setSendBufferSize(UnsignedInteger.valueOf(this.zf.maxBufferSize));
                ((Hello)abstractUaTcpCommMessage).setProtocolVersion(UnsignedInteger.valueOf(0L));
                if (this.ze != null) {
                    ((Hello)abstractUaTcpCommMessage).setProtocolVersion(UnsignedInteger.valueOf(this.zl));
                    ((Hello)abstractUaTcpCommMessage).setMaxChunkCount(UnsignedInteger.valueOf(this.ze.maxRecvChunkCount));
                    ((Hello)abstractUaTcpCommMessage).setMaxMessageSize(UnsignedInteger.valueOf(this.ze.maxRecvMessageSize));
                    ((Hello)abstractUaTcpCommMessage).setSendBufferSize(UnsignedInteger.valueOf(this.ze.maxSendBufferSize));
                    ((Hello)abstractUaTcpCommMessage).setReceiveBufferSize(UnsignedInteger.valueOf(this.ze.maxRecvBufferSize));
                }
                logger.debug("Writing Hello: {}", (Object)abstractUaTcpCommMessage);
                SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
                BinaryEncoder binaryEncoder2 = new BinaryEncoder(this.ctx, sizeCalculationOutputStream);
                littleEndianOutputStreamWriteable.putInt(1179403592);
                InternalBinaryEncodingsHelper.putUaTcpCommMessage(binaryEncoder2, abstractUaTcpCommMessage);
                int n2 = sizeCalculationOutputStream.getLength() + 8;
                littleEndianOutputStreamWriteable.putInt(n2);
                InternalBinaryEncodingsHelper.putUaTcpCommMessage(binaryEncoder, abstractUaTcpCommMessage);
                littleEndianOutputStreamWriteable.flush();
                int n3 = -1;
                while (n3 == -1) {
                    try {
                        n3 = littleEndianInputStreamReadable.getInt();
                    }
                    catch (EOFException eOFException) {
                        n3 = littleEndianInputStreamReadable.getInt();
                    }
                }
                n2 = littleEndianInputStreamReadable.getInt();
                if (n2 < 8 || n2 > 4096) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
                }
                if (n3 == 1179800133) {
                    binaryDecoder.getEncoderContext().setMaxStringLength(4096);
                    ErrorMessage errorMessage = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, ErrorMessage.class);
                    throw new ServiceResultException(StatusCode.valueOf(errorMessage.getError()), errorMessage.getReason());
                }
                if (n3 != 1179337537) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpMessageTypeInvalid, "Message type was " + n3 + ", expected " + 1179337537);
                }
                Acknowledge acknowledge = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, Acknowledge.class);
                logger.debug("Received Acknowledge: {}", (Object)acknowledge);
                if (acknowledge.getProtocolVersion().intValue() < ((Hello)abstractUaTcpCommMessage).getProtocolVersion().intValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_ProtocolVersionUnsupported, "Version " + ((Hello)abstractUaTcpCommMessage).getProtocolVersion().intValue() + " requested, got " + acknowledge.getProtocolVersion());
                }
                this.zl = Math.min(((Hello)abstractUaTcpCommMessage).getProtocolVersion().intValue(), acknowledge.getProtocolVersion().intValue());
                if (acknowledge.getMaxMessageSize().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxMessageSize(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getMaxChunkCount().equals(UnsignedInteger.valueOf(0L))) {
                    acknowledge.setMaxChunkCount(UnsignedInteger.valueOf(Integer.MAX_VALUE));
                }
                if (acknowledge.getReceiveBufferSize().longValue() > ((Hello)abstractUaTcpCommMessage).getReceiveBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.ReceiveBufferSize > Hello.ReceiveBufferSize");
                }
                if (acknowledge.getReceiveBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server recv buffer size < 8192");
                }
                if (acknowledge.getSendBufferSize().longValue() > ((Hello)abstractUaTcpCommMessage).getSendBufferSize().longValue()) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Acknowledge.SendBufferSize > Hello.SendBufferSize");
                }
                if (acknowledge.getSendBufferSize().longValue() < 8192L) {
                    throw new ServiceResultException(StatusCodes.Bad_TcpInternalError, "Server send buffer size < 8192");
                }
                this.ze = new TcpConnectionLimits();
                this.ze.maxSendBufferSize = (int)Math.min(acknowledge.getSendBufferSize().longValue(), Integer.MAX_VALUE);
                this.ze.maxRecvBufferSize = (int)Math.min(acknowledge.getReceiveBufferSize().longValue(), Integer.MAX_VALUE);
                this.ze.maxSendChunkCount = (int)Math.min(acknowledge.getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.ze.maxRecvChunkCount = (int)Math.min(((Hello)abstractUaTcpCommMessage).getMaxChunkCount().longValue(), Integer.MAX_VALUE);
                this.ze.maxSendMessageSize = (int)Math.min(acknowledge.getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                this.ze.maxRecvMessageSize = (int)Math.min(((Hello)abstractUaTcpCommMessage).getMaxMessageSize().longValue(), Integer.MAX_VALUE);
                socketWrapper.setSoTimeout(0);
                socketWrapper.setKeepAlive(true);
                if (this.zp) {
                    logger.info("Connected (reverse), handshake completed, local={}, remote={}", (Object)socketWrapper.getLocalSocketAddress(), (Object)socketWrapper.getRemoteSocketAddress());
                } else {
                    logger.info("Connected (non-reverse), handshake completed, local={}, remote={}", (Object)socketWrapper.getLocalSocketAddress(), (Object)socketWrapper.getRemoteSocketAddress());
                }
                for (IConnectionListener iConnectionListener : this.zo) {
                    iConnectionListener.onOpen();
                }
                logger.debug("Creating ReadThread");
                this.zn = new b(socketWrapper, binaryDecoder.getEncoderContext());
                this.zn.start();
                this.ctx = binaryEncoder.getEncoderContext();
                this.zm = littleEndianOutputStreamWriteable;
            }
            catch (IOException iOException) {
                try {
                    socketWrapper.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", (Throwable)iOException);
                throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
            }
            catch (ServiceResultException serviceResultException) {
                try {
                    socketWrapper.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.setSocket(null);
                logger.info(this.addr + " Connect failed", (Throwable)serviceResultException);
                throw serviceResultException;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void reconnect() throws ServiceResultException {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper != null && socketWrapper.isConnected() && !socketWrapper.isClosed()) {
                this.close();
            }
            this.open();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeConnectionListener(IConnectionListener iConnectionListener) {
        this.zo.remove(iConnectionListener);
    }

    @Override
    public void removeMessageListener(IConnection.IMessageListener iMessageListener) {
        this.listeners.remove(iMessageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(ServiceRequest serviceRequest, int n2, int n3) throws ServiceResultException {
        block16: {
            if (serviceRequest == null) {
                logger.warn("sendRequest: request=null");
            }
            boolean bl = serviceRequest instanceof OpenSecureChannelRequest;
            SocketWrapper socketWrapper = this.getSocket();
            logger.debug("sendRequest: socket={}", (Object)socketWrapper);
            try {
                ByteBuffer[] byteBufferArray;
                ByteBuffer[] byteBufferArray2;
                a a2;
                if (socketWrapper == null || !socketWrapper.isConnected() || socketWrapper.isClosed()) {
                    throw new ServiceResultException(StatusCodes.Bad_ServerNotConnected);
                }
                logger.debug("sendRequest: {} Sending Request rid:{}", (Object)n2, (Object)n3);
                logger.trace("sendrequest: request={}", (Object)serviceRequest);
                SecurityToken securityToken = null;
                SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
                BinaryEncoder binaryEncoder = new BinaryEncoder(this.ctx, sizeCalculationOutputStream);
                InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, serviceRequest);
                int n4 = sizeCalculationOutputStream.getLength();
                if (n2 != 0) {
                    securityToken = this.u(n2);
                }
                logger.debug("sendRequest: token={}", (Object)securityToken);
                SecurityMode securityMode = this.a(bl, serviceRequest, securityToken);
                int n5 = securityToken != null ? securityToken.getSecurityPolicy().getEncryptionKeySize() : 0;
                logger.debug("sendRequest: keySize={}", (Object)n5);
                ChunkFactory chunkFactory = this.a(bl, securityMode, n5);
                if (chunkFactory == null || (a2 = this.a(chunkFactory, n4, serviceRequest)) == null || !((byteBufferArray2 = a2.eCD()) != null & (byteBufferArray = a2.eCE()) != null)) break block16;
                try {
                    this.lock.lock();
                    try {
                        if (bl) {
                            ByteString byteString = ((OpenSecureChannelRequest)serviceRequest).getClientNonce();
                            this.zi.put(n3, byteString);
                            for (int i2 = 0; i2 < byteBufferArray2.length; ++i2) {
                                boolean bl2 = i2 == byteBufferArray2.length - 1;
                                this.a(n2, n3, securityMode, byteBufferArray2[i2], byteBufferArray[i2], bl2);
                                byteBufferArray[i2] = null;
                                byteBufferArray2[i2] = null;
                            }
                        } else {
                            this.zh.put(n2, securityToken);
                            SequenceNumber sequenceNumber = this.zj.get(n2);
                            for (int i3 = 0; i3 < byteBufferArray2.length; ++i3) {
                                ByteBuffer byteBuffer = byteBufferArray2[i3];
                                ByteBuffer byteBuffer2 = byteBufferArray[i3];
                                boolean bl3 = byteBuffer == byteBufferArray2[byteBufferArray2.length - 1];
                                int n6 = 1128747853;
                                if (bl3) {
                                    n6 = 1179079501;
                                }
                                if (serviceRequest instanceof CloseSecureChannelRequest) {
                                    n6 = 1179601987;
                                }
                                this.a(n3, securityToken, sequenceNumber, byteBuffer, byteBuffer2, n6);
                                byteBufferArray[i3] = null;
                                byteBufferArray2[i3] = null;
                            }
                        }
                        this.zm.flush();
                    }
                    catch (IOException iOException) {
                        this.zi.remove(n3);
                        logger.info(this.addr + " Connect failed", (Throwable)iOException);
                        this.close();
                        throw new ServiceResultException(StatusCodes.Bad_CommunicationError, (Throwable)iOException);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.warn(String.format(Locale.ROOT, "sendRequest %s failed: socket=%s, asymm=%s", serviceRequest.getClass().getName(), socketWrapper, bl), (Throwable)runtimeException);
                throw runtimeException;
            }
        }
    }

    public void setHandshakeTimeout(int n2) {
        this.yB = n2;
    }

    public void setReverseHelloAcceptTimeout(int n2) {
        this.yC = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ServiceResultException serviceResultException) {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.getSocket();
            if (socketWrapper == null || !socketWrapper.isConnected() || socketWrapper.isClosed()) {
                return;
            }
            try {
                socketWrapper.close();
            }
            catch (IOException iOException) {
                logger.warn(this.addr + " Close error", (Throwable)iOException);
            }
            this.setSocket(null);
            this.zi.clear();
            logger.info(this.addr + " Closed");
        }
        finally {
            this.lock.unlock();
        }
        for (IConnectionListener iConnectionListener : this.zo) {
            iConnectionListener.onClosed(serviceResultException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private a a(ChunkFactory chunkFactory, int n2, ServiceRequest<?> serviceRequest) throws ServiceResultException {
        int n3;
        if (this.ctx.getMaxMessageSize() != 0 && n2 > this.ctx.getMaxMessageSize()) {
            EncodingException encodingException = new EncodingException(StatusCodes.Bad_EncodingLimitsExceeded, "MaxMessageSize " + this.ctx.getMaxMessageSize() + " < " + n2);
            logger.warn("encodeMessage: failed", (Throwable)encodingException);
            throw encodingException;
        }
        int n4 = (n2 + chunkFactory.maxPlaintextSize - 1) / chunkFactory.maxPlaintextSize;
        this.lock.lock();
        try {
            if (this.ze == null) {
                a a2 = null;
                return a2;
            }
            n3 = this.ze.maxSendChunkCount;
        }
        finally {
            this.lock.unlock();
        }
        if (n3 != 0 && n4 > n3) {
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
        }
        int n5 = n2;
        ByteBuffer[] byteBufferArray = new ByteBuffer[n4];
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            byteBufferArray[i2] = chunkFactory.allocate(n5);
            byteBufferArray2[i2] = chunkFactory.expandToCompleteChunk(byteBufferArray[i2]);
            n5 -= byteBufferArray[i2].remaining();
        }
        ByteBufferArrayWriteable2.ChunkListener chunkListener = new ByteBufferArrayWriteable2.ChunkListener(){

            @Override
            public void onChunkComplete(ByteBuffer[] byteBufferArray, int n2) {
            }
        };
        ByteBufferArrayWriteable2 byteBufferArrayWriteable2 = new ByteBufferArrayWriteable2(byteBufferArray, chunkListener);
        byteBufferArrayWriteable2.order(ByteOrder.LITTLE_ENDIAN);
        BinaryEncoder binaryEncoder = new BinaryEncoder(this.ctx, byteBufferArrayWriteable2);
        InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, serviceRequest);
        return new a(byteBufferArray2, byteBufferArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkFactory a(boolean bl, SecurityMode securityMode, int n2) throws ServiceResultException {
        int n3;
        MessageSecurityMode messageSecurityMode = securityMode.getMessageSecurityMode();
        this.lock.lock();
        try {
            if (this.ze == null) {
                ChunkFactory chunkFactory = null;
                return chunkFactory;
            }
            n3 = this.ze.maxSendBufferSize;
        }
        finally {
            this.lock.unlock();
        }
        if (bl) {
            return new ChunkFactory.AsymmMsgChunkFactory(n3, this.securityConfiguration);
        }
        SecurityPolicy securityPolicy = securityMode.getSecurityPolicy();
        SecurityAlgorithm securityAlgorithm = securityPolicy.getSymmetricEncryptionAlgorithm();
        SecurityAlgorithm securityAlgorithm2 = securityPolicy.getSymmetricSignatureAlgorithm();
        int n4 = CryptoUtil.getCipherBlockSize(securityAlgorithm, null);
        int n5 = CryptoUtil.getSignatureSize(securityAlgorithm2, null);
        return new ChunkFactory(n3, 8, 8, 8, n5, n4, messageSecurityMode, n2);
    }

    private SecurityMode a(boolean bl, ServiceRequest<?> serviceRequest, SecurityToken securityToken) {
        SecurityPolicy securityPolicy;
        MessageSecurityMode messageSecurityMode;
        if (bl) {
            messageSecurityMode = ((OpenSecureChannelRequest)serviceRequest).getSecurityMode();
            securityPolicy = this.securityConfiguration.getSecurityMode().getSecurityPolicy();
        } else {
            messageSecurityMode = securityToken.getMessageSecurityMode();
            securityPolicy = securityToken.getSecurityPolicy();
        }
        return new SecurityMode(securityPolicy, messageSecurityMode);
    }

    private SecurityToken u(int n2) throws ServiceResultException {
        this.eCo();
        SecurityToken securityToken = null;
        logger.debug("tokens={}", this.zg);
        for (SecurityToken securityToken2 : this.zg) {
            if (securityToken2.getSecureChannelId() != n2 || securityToken != null && securityToken.getCreationTime() >= securityToken2.getCreationTime()) continue;
            securityToken = securityToken2;
        }
        logger.debug("getSecurityTokenToUse={}", securityToken);
        if (securityToken == null) {
            throw new ServiceResultException(StatusCodes.Bad_CommunicationError, "All security tokens have expired");
        }
        return securityToken;
    }

    private void eCB() {
        int n2 = Math.min(this.gw.getMaxMessageSize() != null ? this.gw.getMaxMessageSize() : Integer.MAX_VALUE, this.zf.maxMessageSize);
        this.ctx.setMaxMessageSize(n2);
        this.ctx.setMaxArrayLength(this.gw.getMaxArrayLength() != null ? this.gw.getMaxArrayLength() : 0);
        this.ctx.setMaxStringLength(this.gw.getMaxStringLength() != null ? this.gw.getMaxStringLength() : 0);
        this.ctx.setMaxByteStringLength(this.gw.getMaxByteStringLength() != null ? this.gw.getMaxByteStringLength() : 0);
    }

    private void eCo() {
        logger.debug("pruneInvalidTokens: tokens({})={}", (Object)this.zg.size(), this.zg);
        for (SecurityToken securityToken : this.zg) {
            if (securityToken.isValid()) continue;
            this.zg.remove(securityToken);
        }
    }

    private ReverseHello a(LittleEndianInputStreamReadable littleEndianInputStreamReadable, BinaryDecoder binaryDecoder) throws IOException, ServiceResultException, DecodingException {
        int n2 = -1;
        while (n2 == -1) {
            try {
                n2 = littleEndianInputStreamReadable.getInt();
            }
            catch (EOFException eOFException) {
                n2 = littleEndianInputStreamReadable.getInt();
            }
        }
        int n3 = littleEndianInputStreamReadable.getInt();
        if (n3 < 8 || n3 > 4096) {
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
        }
        if (n2 != 1178945618) {
            logger.error("Did not receive correct message type, expecting: {}, got: {}", (Object)1178945618, (Object)n2);
            throw new ServiceResultException(StatusCodes.Bad_TcpMessageTypeInvalid, "Message type was " + n2 + ", expected " + 1178945618);
        }
        ReverseHello reverseHello = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, ReverseHello.class);
        return reverseHello;
    }

    private void a(int n2, int n3, SecurityMode securityMode, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) throws ServiceResultException, IOException {
        SequenceNumber sequenceNumber;
        byteBuffer.rewind();
        byteBuffer.putInt(bl ? 1179537487 : 1129205839);
        byteBuffer.position(8);
        byteBuffer.putInt(n2);
        byte[] byArray = securityMode.getSecurityPolicy().getEncodedPolicyUri();
        byteBuffer.putInt(byArray.length);
        byteBuffer.put(byArray);
        byArray = this.securityConfiguration.getEncodedLocalCertificate();
        byteBuffer.putInt(byArray == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        byteBuffer.putInt((byArray = this.securityConfiguration.getEncodedRemoteCertificateThumbprint()) == null ? -1 : byArray.length);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        int n4 = (sequenceNumber = this.zj.get(n2)) == null ? 1 : sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n4);
        byteBuffer.putInt(n3);
        logger.debug("SecureChannelId={} SequenceNumber={}, RequestId={}", new Object[]{n2, n4, n3});
        try {
            new ChunkAsymmEncryptSigner(byteBuffer, byteBuffer2, this.securityConfiguration).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.zm.put(byteBuffer);
    }

    private void a(int n2, SecurityToken securityToken, SequenceNumber sequenceNumber, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n3) throws ServiceResultException, IOException {
        byteBuffer.rewind();
        byteBuffer.putInt(n3);
        byteBuffer.position(8);
        byteBuffer.putInt(securityToken.getSecureChannelId());
        byteBuffer.putInt(securityToken.getTokenId());
        int n4 = sequenceNumber.getNextSendSequencenumber();
        byteBuffer.putInt(n4);
        byteBuffer.putInt(n2);
        try {
            new ChunkSymmEncryptSigner(byteBuffer, byteBuffer2, securityToken).run();
        }
        catch (RuntimeServiceResultException runtimeServiceResultException) {
            throw runtimeServiceResultException.getCause();
        }
        byteBuffer.rewind();
        this.zm.put(byteBuffer);
    }

    protected SocketWrapper getSocket() {
        this.lock.lock();
        try {
            SocketWrapper socketWrapper = this.zk;
            return socketWrapper;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setSocket(SocketWrapper socketWrapper) {
        this.zk = socketWrapper;
    }

    class b
    extends Thread {
        SocketWrapper zw;
        EncoderContext ctx;
        ServiceResultException kY;
        LinkedBlockingQueue<Runnable> zx;
        AtomicBoolean zy;
        Object zz;
        boolean zA;

        b(SocketWrapper socketWrapper, EncoderContext encoderContext) {
            super("TcpConnection/Read");
            this.kY = null;
            this.zx = new LinkedBlockingQueue();
            this.zy = new AtomicBoolean(false);
            this.zz = new Object();
            this.zA = false;
            this.setDaemon(true);
            this.zw = socketWrapper;
            this.ctx = encoderContext;
        }

        @Override
        public void run() {
            block49: {
                try {
                    LittleEndianInputStreamReadable littleEndianInputStreamReadable = new LittleEndianInputStreamReadable(new BufferedInputStream(this.zw.getInputStream()), Long.MAX_VALUE);
                    ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(256);
                    while (this.zw == TcpConnection.this.getSocket()) {
                        int n2;
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        int n3;
                        arrayList.clear();
                        int n4 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = 0;
                        do {
                            Object object5;
                            if (n5 > TcpConnection.this.ze.maxRecvChunkCount) {
                                this.kY = new ServiceResultException("Recv chunk count exceeded (max = " + n5 + ")");
                                logger.warn("{} Recv chunk count exceeded (max = {})", (Object)TcpConnection.this.addr, (Object)n5);
                                break block49;
                            }
                            int n9 = littleEndianInputStreamReadable.getInt();
                            n3 = n9 & 0xFFFFFF;
                            n6 = n9 & 0xFF000000;
                            if (n5 == 0) {
                                n4 = n3;
                            } else if (n3 != n4) {
                                this.kY = new ServiceResultException("Error, message type changed between chunks");
                                logger.warn("{} Error, message type changed between chunks", (Object)TcpConnection.this.addr);
                                break block49;
                            }
                            if (n3 != 5132367 && n3 != 4674381 && n9 != 1179800133) {
                                this.kY = new ServiceResultException("Error, unknown message type " + String.format(Locale.ROOT, "0x%08x", n9));
                                logger.warn("{} Error, unknown message type {}", (Object)TcpConnection.this.addr, (Object)String.format(Locale.ROOT, "0x%08x", n9));
                                break block49;
                            }
                            int n10 = littleEndianInputStreamReadable.getInt();
                            if (n10 > TcpConnection.this.ze.maxRecvBufferSize) {
                                this.kY = new ServiceResultException("Error, chunk too large (max = " + TcpConnection.this.ze.maxRecvBufferSize + ")");
                                logger.warn("{} Error, chunk too large (max = {})", (Object)TcpConnection.this.addr, (Object)TcpConnection.this.ze.maxRecvBufferSize);
                                break block49;
                            }
                            object4 = ByteBuffer.allocate(n10);
                            ((ByteBuffer)object4).order(ByteOrder.LITTLE_ENDIAN);
                            ((ByteBuffer)object4).putInt(n9);
                            ((ByteBuffer)object4).putInt(n10);
                            littleEndianInputStreamReadable.get((ByteBuffer)object4, n10 - 8);
                            if (n9 == 1179800133) {
                                ServiceResultException serviceResultException;
                                ((ByteBuffer)object4).position(8);
                                BinaryDecoder binaryDecoder = new BinaryDecoder(this.ctx, (ByteBuffer)object4);
                                ErrorMessage errorMessage = InternalBinaryEncodingsHelper.getUaTcpCommMessage(binaryDecoder, ErrorMessage.class);
                                this.kY = serviceResultException = new ServiceResultException(errorMessage.getError(), errorMessage.getReason());
                                logger.warn(this.zw.getRemoteSocketAddress() + " Error", (Throwable)serviceResultException);
                                break block49;
                            }
                            int n11 = ChunkUtils.getSecureChannelId((ByteBuffer)object4);
                            if (n5 == 0) {
                                n8 = n11;
                            } else if (n8 != n11) {
                                this.kY = new ServiceResultException("Error, SecureChannelId mismatch");
                                logger.warn("{} Error, SecureChannelId mismatch", (Object)TcpConnection.this.addr);
                                break block49;
                            }
                            if (n4 == 5132367) {
                                try {
                                    Object object6;
                                    String string = ChunkUtils.getSecurityPolicyUri((ByteBuffer)object4);
                                    object3 = SecurityPolicy.getSecurityPolicy(string);
                                    object5 = ChunkUtils.getByteString((ByteBuffer)object4);
                                    object2 = ChunkUtils.getByteString((ByteBuffer)object4);
                                    if (object3 != TcpConnection.this.securityConfiguration.getSecurityPolicy()) {
                                        this.kY = new ServiceResultException("Error, unexpected security policy in OpenSecureChannelResponse");
                                        logger.warn("{} Error, unexpected security policy in OpenSecureChannelResponse", (Object)TcpConnection.this.addr);
                                        break block49;
                                    }
                                    if (TcpConnection.this.securityConfiguration.getSecurityPolicy() != SecurityPolicy.NONE && !Arrays.equals((byte[])object2, TcpConnection.this.securityConfiguration.getEncodedLocalCertificateThumbprint())) {
                                        this.kY = new ServiceResultException("Error, certificate thumbprint mismatch");
                                        logger.warn("{} Error, certificate thumbprint mismatch", (Object)TcpConnection.this.addr);
                                        break block49;
                                    }
                                    object = null;
                                    if (object5 != null && ((Object)object5).length > 0) {
                                        try {
                                            object = new Cert(CertificateUtils.decodeX509Certificate((byte[])object5));
                                        }
                                        catch (CertificateException certificateException) {
                                            this.kY = new ServiceResultException(StatusCodes.Bad_CertificateInvalid, "Error, Invalid Remote Certificate");
                                            logger.warn(TcpConnection.this.addr + " Error, Invalid Remote Certificate", (Throwable)certificateException);
                                            break block49;
                                        }
                                    }
                                    if (TcpConnection.this.cH != null && (object6 = TcpConnection.this.cH.validateCertificate((Cert)object)) != null && !((StatusCode)object6).isGood()) {
                                        this.kY = new ServiceResultException((StatusCode)object6, "Remote certificate not accepted");
                                        logger.info("{} Remote certificate not accepted: {}", (Object)TcpConnection.this.addr, object6);
                                        break block49;
                                    }
                                    TcpConnection.this.securityConfiguration = new SecurityConfiguration(TcpConnection.this.securityConfiguration.getSecurityMode(), TcpConnection.this.securityConfiguration.getLocalCertificate2(), (Cert)object);
                                    object6 = new ChunkAsymmDecryptVerifier((ByteBuffer)object4, TcpConnection.this.securityConfiguration);
                                    ((ChunkAsymmDecryptVerifier)object6).run();
                                }
                                catch (ServiceResultException serviceResultException) {
                                    this.kY = serviceResultException;
                                    logger.warn(TcpConnection.this.addr + "", (Throwable)serviceResultException);
                                    break block49;
                                }
                            }
                            if (n4 == 4674381) {
                                int n12 = ChunkUtils.getTokenId((ByteBuffer)object4);
                                object3 = null;
                                logger.debug("tokens({})={}", (Object)TcpConnection.this.zg.size(), TcpConnection.this.zg);
                                object5 = TcpConnection.this.zg.iterator();
                                while (object5.hasNext()) {
                                    object2 = (SecurityToken)object5.next();
                                    if (((SecurityToken)object2).getTokenId() != n12 || ((SecurityToken)object2).getSecureChannelId() != n11) continue;
                                    object3 = object2;
                                }
                                logger.debug("token={}", object3);
                                if (object3 == null) {
                                    this.kY = new ServiceResultException("Unexpected securityTokenId = " + n12);
                                    logger.warn("{} Unexpected securityTokenId = {}", (Object)TcpConnection.this.addr, (Object)n12);
                                    break block49;
                                }
                                if (!((SecurityToken)object3).isValid()) {
                                    this.kY = new ServiceResultException("SecurityToken " + n12 + " has timeouted");
                                    logger.warn("{} SecurityToken {} has timeouted", (Object)TcpConnection.this.addr, object3);
                                    break block49;
                                }
                                TcpConnection.this.zh.put(n11, (SecurityToken)object3);
                                object5 = new ChunkSymmDecryptVerifier((ByteBuffer)object4, (SecurityToken)object3);
                                ((ChunkSymmDecryptVerifier)object5).run();
                                ((ByteBuffer)object4).position(24);
                            }
                            ((ByteBuffer)object4).position(((Buffer)object4).position() - 8);
                            n2 = ((ByteBuffer)object4).getInt();
                            object3 = TcpConnection.this.zj.get(n8);
                            if (!(n4 != 4674381 && object3 == null || ((SequenceNumber)object3).testAndSetRecvSequencenumber(n2))) {
                                this.kY = new ServiceResultException("Sequence number mismatch");
                                logger.warn("{} Sequence number mismatch: {} vs. {}", new Object[]{TcpConnection.this.addr, ((SequenceNumber)object3).getRecvSequenceNumber(), n2});
                                break block49;
                            }
                            int n13 = ((ByteBuffer)object4).getInt();
                            if (n5 == 0) {
                                n7 = n13;
                            } else if (n13 != n7) {
                                this.kY = new ServiceResultException("Request id mismatch");
                                logger.warn("{} Request id mismatch", (Object)TcpConnection.this.addr);
                                break block49;
                            }
                            arrayList.add((ByteBuffer)object4);
                            ++n5;
                        } while (n6 == 0x43000000);
                        if (n6 == 0x41000000) continue;
                        ByteBufferArrayReadable byteBufferArrayReadable = new ByteBufferArrayReadable(arrayList.toArray(new ByteBuffer[0]));
                        n3 = (int)byteBufferArrayReadable.remaining();
                        byte[] byArray = new byte[n3];
                        byteBufferArrayReadable.get(byArray);
                        object4 = new BinaryDecoder(this.ctx, byArray);
                        NodeId nodeId = object4.getNodeId(null);
                        if (Identifiers.OpenSecureChannelResponse_Encoding_DefaultBinary.equals(nodeId)) {
                            block50: {
                                object4 = new BinaryDecoder(this.ctx, byArray);
                                ServiceResponse serviceResponse = InternalBinaryEncodingsHelper.getServiceResponse((BinaryDecoder)object4);
                                object3 = (OpenSecureChannelResponse)serviceResponse;
                                ChannelSecurityToken channelSecurityToken = ((OpenSecureChannelResponse)object3).getSecurityToken();
                                object2 = TcpConnection.this.zi.get(n7);
                                object = ((OpenSecureChannelResponse)object3).getServerNonce();
                                int n14 = n8;
                                int n15 = channelSecurityToken.getChannelId().intValue();
                                if (n15 != n14) {
                                    logger.warn("{} OpenSecureChannel, server sent two secureChannelIds {} and {} using {}", new Object[]{TcpConnection.this.addr, n14, n15, n14});
                                }
                                try {
                                    SecurityToken securityToken = new SecurityToken(TcpConnection.this.securityConfiguration, n14, channelSecurityToken.getTokenId().intValue(), System.currentTimeMillis(), channelSecurityToken.getRevisedLifetime().longValue(), (ByteString)object2, (ByteString)object);
                                    logger.debug("new token={}", (Object)securityToken);
                                    TcpConnection.this.zg.add(securityToken);
                                    if (TcpConnection.this.zj.containsKey(n14)) break block50;
                                    TcpConnection.this.zj.put(n14, new SequenceNumber());
                                }
                                catch (ServiceResultException serviceResultException) {
                                    this.kY = serviceResultException;
                                    logger.warn(TcpConnection.this.addr + " SecurityTokenError ", (Throwable)serviceResultException);
                                    break;
                                }
                            }
                            TcpConnection.this.zi.remove(n7);
                            int n16 = n7;
                            int n17 = n8;
                            for (IConnection.IMessageListener iMessageListener : TcpConnection.this.listeners) {
                                iMessageListener.onMessage(n16, n17, (IEncodeable)object3);
                            }
                            continue;
                        }
                        if (Identifiers.PublishResponse_Encoding_DefaultBinary.equals(nodeId)) {
                            TcpConnection.this.zi.remove(n7);
                            n2 = n7;
                            int n18 = n8;
                            this.zx.add(() -> this.a(byArray, n2, n18));
                            this.eCG();
                            continue;
                        }
                        TcpConnection.this.zi.remove(n7);
                        n2 = n7;
                        int n19 = n8;
                        zc.get(TcpConnection.this).execute(() -> this.a(byArray, n2, n19));
                    }
                }
                catch (IOException iOException) {
                    if (iOException instanceof SocketException) {
                        if (!this.zA) {
                            logger.info("{} Closed (unexpected)", (Object)TcpConnection.this.addr);
                            this.kY = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (unexpected)");
                        } else {
                            logger.info("{} Closed (expected)", (Object)TcpConnection.this.addr);
                            this.kY = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (expected)");
                        }
                    } else if (iOException instanceof EOFException) {
                        this.kY = new ServiceResultException(StatusCodes.Bad_ConnectionClosed, (Throwable)iOException, "Connection closed (graceful)");
                        logger.info("{} Closed (graceful)", (Object)TcpConnection.this.addr);
                    } else {
                        this.kY = StackUtils.toServiceResultException(iOException);
                        logger.warn(TcpConnection.this.addr + " Error", (Throwable)iOException);
                    }
                }
                catch (DecodingException decodingException) {
                    if (decodingException.getCause() != null && decodingException.getCause() instanceof EOFException) {
                        logger.info("{} Closed", (Object)TcpConnection.this.addr);
                    } else {
                        logger.warn(TcpConnection.this.addr + " Error", (Throwable)decodingException);
                    }
                    this.kY = decodingException;
                }
                catch (RuntimeServiceResultException runtimeServiceResultException) {
                    ServiceResultException serviceResultException = runtimeServiceResultException.getCause();
                    logger.warn(TcpConnection.this.addr + " Error", (Throwable)serviceResultException);
                    this.kY = serviceResultException;
                }
                catch (Exception exception) {
                    this.kY = new ServiceResultException(StatusCodes.Bad_InternalError, (Throwable)exception);
                    logger.error("Error in ReadThread", (Throwable)this.kY);
                }
                catch (StackOverflowError stackOverflowError) {
                    this.kY = new ServiceResultException(StatusCodes.Bad_DecodingError, (Throwable)stackOverflowError);
                    logger.error("Error in ReadThread", (Throwable)this.kY);
                }
            }
            TcpConnection.this.a(this.kY);
        }

        private void a(byte[] byArray, int n2, int n3) {
            IEncodeable iEncodeable;
            BinaryDecoder binaryDecoder = new BinaryDecoder(this.ctx, byArray);
            AtomicReference atomicReference = new AtomicReference();
            binaryDecoder.setStructureFieldDecodeListener((fieldSpecification, object) -> {
                if (UaIds.ResponseHeader.equals(fieldSpecification.getDataTypeId()) && "ResponseHeader".equals(fieldSpecification.getName())) {
                    atomicReference.compareAndSet(null, (ResponseHeader)object);
                }
            });
            try {
                iEncodeable = InternalBinaryEncodingsHelper.getMessage(binaryDecoder);
            }
            catch (DecodingException decodingException) {
                ResponseHeader object2 = (ResponseHeader)atomicReference.get();
                if (object2 == null) {
                    logger.error("Decoding error for Message", (Throwable)decodingException);
                    return;
                }
                iEncodeable = new InternalClientSideDecodingServiceFault(object2, decodingException);
            }
            for (IConnection.IMessageListener iMessageListener : TcpConnection.this.listeners) {
                iMessageListener.onMessage(n2, n3, iEncodeable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eCF() {
            Object object;
            try {
                object = new ArrayList();
                this.zx.drainTo((Collection<Runnable>)object);
                object.forEach(runnable -> runnable.run());
            }
            finally {
                object = this.zz;
                synchronized (object) {
                    if (this.zx.isEmpty()) {
                        this.zy.set(false);
                    } else {
                        zc.get(TcpConnection.this).execute(() -> this.eCF());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eCG() {
            Object object = this.zz;
            synchronized (object) {
                if (!this.zy.get()) {
                    this.zy.set(true);
                    zc.get(TcpConnection.this).execute(() -> this.eCF());
                }
            }
        }
    }

    private class a {
        private ByteBuffer[] zu;
        private ByteBuffer[] zv;

        public a(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
            this.zu = byteBufferArray;
            this.zv = byteBufferArray2;
        }

        public ByteBuffer[] eCD() {
            return this.zu;
        }

        public ByteBuffer[] eCE() {
            return this.zv;
        }
    }

    public static interface SocketWrapper {
        public void close() throws IOException;

        public void connect(InetSocketAddress var1) throws IOException;

        public void connect(InetSocketAddress var1, int var2) throws IOException;

        public InputStream getInputStream() throws IOException;

        public SocketAddress getLocalSocketAddress();

        public OutputStream getOutputStream() throws IOException;

        public SocketAddress getRemoteSocketAddress();

        public boolean isClosed();

        public boolean isConnected();

        public void setKeepAlive(boolean var1) throws IOException;

        public void setReceiveBufferSize(int var1) throws IOException;

        public void setSendBufferSize(int var1) throws IOException;

        public void setSoTimeout(int var1) throws IOException;

        public void setTcpNoDelay(boolean var1) throws IOException;
    }

    public static interface SocketFactory {
        public SocketWrapper createSocket(TcpConnection var1) throws IOException;
    }

    public static interface ReverseConnectionProvider {
        public SocketWrapper provideOpenReverseConnectionSocket(TcpConnection var1) throws IOException;
    }

    public static interface ExecutorProvider {
        public Executor get(TcpConnection var1);
    }

    public static class DelegatingSocketWrapper
    implements SocketWrapper {
        protected final Socket delegate;

        public DelegatingSocketWrapper(Socket socket) {
            this.delegate = socket;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void connect(InetSocketAddress inetSocketAddress) throws IOException {
            this.delegate.connect(inetSocketAddress);
        }

        @Override
        public void connect(InetSocketAddress inetSocketAddress, int n2) throws IOException {
            this.delegate.connect(inetSocketAddress, n2);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.delegate.getLocalSocketAddress();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.delegate.getRemoteSocketAddress();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public boolean isConnected() {
            return this.delegate.isConnected();
        }

        @Override
        public void setKeepAlive(boolean bl) throws IOException {
            this.delegate.setKeepAlive(bl);
        }

        @Override
        public void setReceiveBufferSize(int n2) throws IOException {
            this.delegate.setReceiveBufferSize(n2);
        }

        @Override
        public void setSendBufferSize(int n2) throws IOException {
            this.delegate.setSendBufferSize(n2);
        }

        @Override
        public void setSoTimeout(int n2) throws IOException {
            this.delegate.setSoTimeout(n2);
        }

        @Override
        public void setTcpNoDelay(boolean bl) throws IOException {
            this.delegate.setTcpNoDelay(bl);
        }
    }

    public static class DefaultSocketFactory
    implements SocketFactory {
        @Override
        public SocketWrapper createSocket(TcpConnection tcpConnection) {
            return new DelegatingSocketWrapper(new Socket());
        }
    }

    public static class DefaultReverseConnectionProvider
    implements ReverseConnectionProvider {
        @Override
        public SocketWrapper provideOpenReverseConnectionSocket(TcpConnection tcpConnection) throws IOException {
            final ServerSocket serverSocket = new ServerSocket();
            serverSocket.bind(tcpConnection.addr);
            logger.info("Opened ServerSocket at:{}, waiting ReverseHello connection", (Object)tcpConnection.addr);
            if (tcpConnection.yC > 0) {
                TimerUtil.getTimer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException iOException) {
                            logger.error("Could not close ServerSocket in timeout", (Throwable)iOException);
                        }
                    }
                }, tcpConnection.yC);
            }
            DelegatingSocketWrapper delegatingSocketWrapper = new DelegatingSocketWrapper(serverSocket.accept());
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                try {
                    delegatingSocketWrapper.delegate.close();
                }
                catch (Exception exception) {
                    logger.warn("Closing ReverseHello related ServerSocket failed and also closing the accepted connection failed", (Throwable)exception);
                }
                throw iOException;
            }
            logger.debug("ReverseHello ServerSocket {} closed.", (Object)tcpConnection.addr);
            return delegatingSocketWrapper;
        }
    }

    public static class DefaultExecutorProvider
    implements ExecutorProvider {
        @Override
        public Executor get(TcpConnection tcpConnection) {
            return StackUtils.getBlockingWorkExecutor();
        }
    }
}

