/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.common.RuntimeServiceResultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.stack.transport.tcp.impl.AbstractUaTcpCommMessage;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkFactory;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.transport.tcp.impl.TcpConnectionParameters;
import com.prosysopc.ua.stack.transport.tcp.nio.MessageType;
import com.prosysopc.ua.stack.utils.SizeCalculationOutputStream;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayWriteable;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteQueue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;

public class MessageToChunks
implements Callable<ByteBuffer[]> {
    MessageType zH;
    IEncodeable uW;
    TcpConnectionParameters zD;
    EncoderContext vy;
    ChunkFactory zI;

    public MessageToChunks(IEncodeable iEncodeable, TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, ChunkFactory chunkFactory, MessageType messageType) {
        if (iEncodeable == null || tcpConnectionParameters == null || chunkFactory == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.uW = iEncodeable;
        this.zD = tcpConnectionParameters;
        this.vy = encoderContext;
        this.zI = chunkFactory;
        this.zH = messageType;
    }

    @Override
    public ByteBuffer[] call() throws RuntimeServiceResultException {
        try {
            SizeCalculationOutputStream sizeCalculationOutputStream = new SizeCalculationOutputStream();
            BinaryEncoder binaryEncoder = new BinaryEncoder(this.vy, sizeCalculationOutputStream);
            this.a(binaryEncoder);
            int n2 = sizeCalculationOutputStream.getLength();
            if (n2 > this.zD.maxSendMessageSize && this.zD.maxSendMessageSize != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            ByteQueue byteQueue = new ByteQueue();
            byteQueue.order(ByteOrder.LITTLE_ENDIAN);
            byteQueue.setWriteLimit(n2);
            byteQueue.setByteBufferFactory(this.zI);
            byteQueue.setChunkSize(this.zI.maxPlaintextSize);
            ByteBufferArrayWriteable byteBufferArrayWriteable = new ByteBufferArrayWriteable(byteQueue);
            byteBufferArrayWriteable.order(ByteOrder.LITTLE_ENDIAN);
            BinaryEncoder binaryEncoder2 = new BinaryEncoder(this.vy, byteBufferArrayWriteable);
            this.a(binaryEncoder2);
            ByteBuffer[] byteBufferArray = byteQueue.getChunks(n2);
            if (byteBufferArray.length > this.zD.maxRecvChunkCount && this.zD.maxRecvChunkCount != 0) {
                throw new ServiceResultException(StatusCodes.Bad_TcpMessageTooLarge);
            }
            return byteBufferArray;
        }
        catch (ServiceResultException serviceResultException) {
            throw new RuntimeServiceResultException(serviceResultException);
        }
    }

    private void a(BinaryEncoder binaryEncoder) throws EncodingException {
        if (this.zH == MessageType.Encodeable) {
            InternalBinaryEncodingsHelper.putUaTcpCommMessage(binaryEncoder, (AbstractUaTcpCommMessage)this.uW);
        } else if (this.uW instanceof ServiceResponse) {
            InternalBinaryEncodingsHelper.putServiceResponse(binaryEncoder, (ServiceResponse)this.uW);
        } else {
            InternalBinaryEncodingsHelper.putServiceRequest(binaryEncoder, (ServiceRequest)this.uW);
        }
    }
}

