/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.transport.tcp.nio;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.transport.security.SecurityConfiguration;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkAsymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkSymmDecryptVerifier;
import com.prosysopc.ua.stack.transport.tcp.impl.ChunkUtils;
import com.prosysopc.ua.stack.transport.tcp.impl.InternalBinaryEncodingsHelper;
import com.prosysopc.ua.stack.transport.tcp.impl.SecurityToken;
import com.prosysopc.ua.stack.transport.tcp.impl.TcpConnectionParameters;
import com.prosysopc.ua.stack.transport.tcp.nio.InputMessage;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferArrayReadable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureInputMessageBuilder
implements InputMessage {
    private static final Logger logger = LoggerFactory.getLogger(SecureInputMessageBuilder.class);
    private final MessageListener Ar;
    private final Object As;
    private final TcpConnectionParameters zD;
    private final EncoderContext vy;
    private Exception At;
    private final List<ByteBuffer> kP = new ArrayList<ByteBuffer>();
    private int Au;
    private IEncodeable uW;
    private Integer Av;
    private Integer Aw;
    private int messageType;
    private boolean Ax = true;
    private boolean done;
    private String vu;
    private byte[] xZ;
    private byte[] ya;
    private final List<Integer> Ay = new ArrayList<Integer>();
    private final AtomicInteger Az;
    private long AA = 0L;

    public SecureInputMessageBuilder(Object object, MessageListener messageListener, TcpConnectionParameters tcpConnectionParameters, EncoderContext encoderContext, AtomicInteger atomicInteger) {
        this.Ar = messageListener;
        this.As = object;
        this.zD = tcpConnectionParameters;
        this.vy = encoderContext;
        this.Az = atomicInteger;
        if (logger.isDebugEnabled()) {
            logger.debug("SecureInputMessageBuilder: expectedSequenceNumber={}", (Object)atomicInteger);
        }
    }

    public synchronized void addChunk(ByteBuffer byteBuffer) throws ServiceResultException {
        Integer n2;
        if (!this.Ax) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Final chunk added to message builder");
        }
        this.AA += (long)byteBuffer.remaining();
        if (logger.isTraceEnabled()) {
            logger.trace("Current message size via chunks: {}", (Object)this.AA);
        }
        if (this.AA > (long)this.vy.getMaxMessageSize()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Max message limits ({}) exceeded, at {}, stopping accepting chunks", (Object)this.vy.getMaxMessageSize(), (Object)this.AA);
            }
            throw new ServiceResultException(StatusCodes.Bad_RequestTooLarge);
        }
        int n3 = this.Au++;
        this.Ay.add(null);
        int n4 = ChunkUtils.getMessageType(byteBuffer);
        int n5 = n4 & 0xFFFFFF;
        int n6 = n4 & 0xFF000000;
        if (n6 == 0x46000000) {
            this.Ax = false;
        }
        Integer n7 = n2 = this.Az != null ? Integer.valueOf(this.Az.getAndIncrement()) : null;
        if (logger.isDebugEnabled()) {
            logger.debug("addChunk: expectedSequenceNumber={}", (Object)n2);
        }
        if (n6 == 0x41000000) {
            this.a((IEncodeable)null);
        }
        if (n3 == 0) {
            this.messageType = n5;
            this.Aw = ChunkUtils.getSecureChannelId(byteBuffer);
        }
        this.kP.add(byteBuffer);
        if (!this.Ax) {
            // empty if block
        }
        this.a(byteBuffer, n3, n2);
        if (!this.Ax) {
            this.eCL();
        }
    }

    public void close() {
        if (this.done) {
            return;
        }
        this.done = true;
    }

    @Override
    public Exception getError() {
        return this.At;
    }

    @Override
    public IEncodeable getMessage() {
        return this.uW;
    }

    @Override
    public int getMessageType() {
        return this.messageType;
    }

    public byte[] getReceiverCertificateThumbprint() {
        return this.ya;
    }

    @Override
    public int getRequestId() {
        return this.Av;
    }

    @Override
    public int getSecureChannelId() {
        return this.Aw;
    }

    public String getSecurityPolicyUri() {
        return this.vu;
    }

    public byte[] getSenderCertificate() {
        return this.xZ;
    }

    @Override
    public List<Integer> getSequenceNumbers() {
        return this.Ay;
    }

    @Override
    public Object getToken() {
        return this.As;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public synchronized boolean moreChunksRequired() {
        return this.Ax;
    }

    public void softClose() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("token=" + this.As);
        stringBuilder.append(", secureChannelId=" + this.Aw);
        stringBuilder.append(", more=" + this.moreChunksRequired());
        return stringBuilder.toString();
    }

    private void eCL() {
        try {
            ByteBufferArrayReadable byteBufferArrayReadable = new ByteBufferArrayReadable(this.kP.toArray(new ByteBuffer[0]));
            BinaryDecoder binaryDecoder = new BinaryDecoder(this.vy, byteBufferArrayReadable);
            IEncodeable iEncodeable = InternalBinaryEncodingsHelper.getMessage(binaryDecoder);
            if (!(this.As instanceof SecurityToken)) {
                for (int i2 = 1; i2 < this.Ay.size(); ++i2) {
                    if (this.Ay.get(i2) == this.Ay.get(i2 - 1) - 1) continue;
                    String string = "Sequence numbers of chunks are not consecutive";
                    if (logger.isInfoEnabled()) {
                        logger.info("Sequence numbers of chunks are not consecutive");
                    }
                    this.a(new ServiceResultException(StatusCodes.Bad_DecodingError, "Sequence numbers of chunks are not consecutive"));
                    return;
                }
            }
            this.a(iEncodeable);
        }
        catch (Exception exception) {
            this.a(exception);
        }
        catch (StackOverflowError stackOverflowError) {
            this.a(new ServiceResultException(StatusCodes.Bad_DecodingError, "Stack overflow: " + Arrays.toString(Arrays.copyOf(stackOverflowError.getStackTrace(), 30)) + "..."));
        }
    }

    private void a(ByteBuffer byteBuffer, int n2, Integer n3) {
        if (this.hasError()) {
            return;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("token: {}", this.As);
            }
            if (this.As instanceof SecurityToken) {
                new ChunkSymmDecryptVerifier(byteBuffer, (SecurityToken)this.As).run();
            } else if (this.As instanceof SecurityConfiguration) {
                ChunkAsymmDecryptVerifier chunkAsymmDecryptVerifier = new ChunkAsymmDecryptVerifier(byteBuffer, (SecurityConfiguration)this.As);
                chunkAsymmDecryptVerifier.run();
                this.vu = chunkAsymmDecryptVerifier.getSecurityPolicyUri();
                this.xZ = chunkAsymmDecryptVerifier.getSenderCertificate();
                this.ya = chunkAsymmDecryptVerifier.getReceiverCertificateThumbprint();
            }
            int n4 = byteBuffer.position();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            byteBuffer.position(n4);
            int n5 = byteBuffer.position();
            byteBuffer.position(n5 - 8);
            int n6 = byteBuffer.getInt();
            this.Ay.set(n2, n6);
            if (n3 != null) {
                if (n6 > n3) {
                    long l2 = System.currentTimeMillis();
                    long l3 = 100L;
                    while (n6 > n3 && System.currentTimeMillis() - l2 < l3) {
                        Thread.sleep(1L);
                    }
                }
                if (n3 != n6) {
                    throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "chunkSequenceNumber=" + n6 + ", expectedSequenceNumber=" + n3);
                }
            }
            int n7 = byteBuffer.getInt();
            this.v(n7);
            int n8 = ChunkUtils.getSecureChannelId(byteBuffer);
            if (n8 != this.Aw) {
                throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "secureChannelId=" + n8 + ", expected Id");
            }
            byteBuffer.position(n5);
            if (logger.isTraceEnabled()) {
                logger.trace("hatching chunk, requestId: {}", (Object)n7);
            }
        }
        catch (Exception exception) {
            if (logger.isInfoEnabled()) {
                logger.info("addChunk: failed", (Throwable)exception);
            }
            this.a(exception);
        }
    }

    private void eCM() {
        if (this.Ar != null) {
            this.Ar.onMessageComplete(this);
        }
    }

    private synchronized boolean hasError() {
        return this.At != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Exception exception) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                if (logger.isInfoEnabled()) {
                    logger.info("setError[when done]", (Throwable)exception);
                }
                return;
            }
            this.done = true;
            this.At = exception;
        }
        this.eCM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IEncodeable iEncodeable) {
        SecureInputMessageBuilder secureInputMessageBuilder = this;
        synchronized (secureInputMessageBuilder) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.uW = iEncodeable;
        }
        this.eCM();
    }

    private synchronized void v(int n2) throws ServiceResultException {
        if (this.Av != null && this.Av != n2) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError);
        }
        this.Av = n2;
    }

    public static interface MessageListener {
        public void onMessageComplete(InputMessage var1);
    }
}

