/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.utils.CurrentThreadExecutor;
import com.prosysopc.ua.stack.utils.IStatefulObject;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.StateListener;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractState<T, E extends Throwable>
implements IStatefulObject<T, E> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractState.class);
    private volatile T state = null;
    private final T AB;
    private volatile E AD;
    private final CopyOnWriteArrayList<StateListener<T>> AE = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<StateListener<T>> AF = new CopyOnWriteArrayList();
    private Object lock = new Object();

    public AbstractState(T t2) {
        this.state = t2;
        this.AB = null;
    }

    public AbstractState(T t2, T t3) {
        this.state = t2;
        this.AB = t3;
    }

    @Override
    public synchronized void addStateListener(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.AE.add(stateListener);
    }

    @Override
    public synchronized void addStateNotifiable(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.AF.add(stateListener);
    }

    @Override
    public E getError() {
        return this.AD;
    }

    @Override
    public synchronized T getState() {
        return this.state;
    }

    public boolean hasError() {
        return this.AD != null;
    }

    @Override
    public synchronized void removeStateListener(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.AE.remove(stateListener);
    }

    @Override
    public synchronized void removeStateNotifiable(StateListener<T> stateListener) {
        if (stateListener == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.AF.remove(stateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T waitForState(Set<T> set) throws InterruptedException, E {
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                this.lock.wait();
            }
            E e2 = this.getError();
            if (e2 != null) {
                throw e2;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T waitForState(Set<T> set, long l2, TimeUnit timeUnit) throws InterruptedException, TimeoutException, E {
        long l3 = System.currentTimeMillis() + timeUnit.toMillis(l2);
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                long l4 = System.currentTimeMillis() - l3;
                if (l4 < 0L) {
                    throw new TimeoutException("timeout");
                }
                this.lock.wait(l4);
                E e2 = this.getError();
                if (e2 == null) continue;
                throw e2;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T waitForStateUninterruptibly(Set<T> set) throws E {
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            E e2 = this.getError();
            if (e2 != null) {
                throw e2;
            }
            return this.state;
        }
    }

    protected T attemptSetState(Set<T> set, T t2) {
        if (set == null || t2 == null) {
            throw new IllegalArgumentException("null arg");
        }
        return this.setState(t2, null, set);
    }

    protected void clearError() {
        this.AD = null;
    }

    protected boolean isStateTransitionAllowed(T t2, T t3) {
        return true;
    }

    protected void onListenerException(RuntimeException runtimeException) {
        logger.trace("onListenerException", (Throwable)runtimeException);
    }

    protected void onStateTransition(T t2, T t3) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(E e2) {
        this.AD = e2;
        if (this.AB == null || !this.setState(this.AB)) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected boolean setState(T t2) {
        return this.setState(t2, null, null) == t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T setState(T t2, Executor executor, Set<T> set) {
        if (executor != null && executor instanceof CurrentThreadExecutor) {
            executor = null;
        }
        T t3 = null;
        Object StateType2 = null;
        Object object = this;
        synchronized (object) {
            t3 = this.state;
            StateType2 = t2;
            if (t3 == StateType2) {
                return t2;
            }
            if (set != null && !set.contains(this.state)) {
                return t2;
            }
            if (!this.isStateTransitionAllowed(t3, StateType2)) {
                return t2;
            }
            this.state = StateType2;
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        this.onStateTransition(t3, StateType2);
        object = t3;
        Object StateType3 = StateType2;
        if (executor == null) {
            for (StateListener<T> stateListener : this.AE) {
                try {
                    stateListener.onStateTransition(this, object, StateType3);
                }
                catch (RuntimeException runtimeException) {
                    this.onListenerException(runtimeException);
                }
            }
        } else {
            for (StateListener<T> stateListener : this.AE) {
                executor.execute(() -> {
                    try {
                        stateListener.onStateTransition(this, object, StateType3);
                    }
                    catch (RuntimeException runtimeException) {
                        this.onListenerException(runtimeException);
                    }
                });
            }
        }
        for (StateListener<T> stateListener : this.AF) {
            StackUtils.getBlockingWorkExecutor().execute(() -> {
                try {
                    stateListener.onStateTransition(this, object, StateType3);
                }
                catch (RuntimeException runtimeException) {
                    this.onListenerException(runtimeException);
                }
            });
        }
        return t2;
    }

    protected void throwIfError() throws E {
        E e2 = this.AD;
        if (e2 != null) {
            throw e2;
        }
    }
}

