/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;

public class NumericRange {
    private int[] Bc;
    private int[] Bd;

    public static NumericRange getEmpty() {
        return new NumericRange();
    }

    public static boolean isNullOrEmpty(NumericRange numericRange) {
        return numericRange == null || numericRange.isEmpty();
    }

    public static NumericRange parse(String string) throws ServiceResultException {
        if (string == null || string.length() == 0) {
            return NumericRange.getEmpty();
        }
        NumericRange numericRange = new NumericRange();
        String[] stringArray = string.split(",");
        numericRange.setDimensions(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                String string2 = stringArray[i2];
                String[] stringArray2 = string2.split(":");
                if (stringArray2.length > 1) {
                    numericRange.setBegin(i2, Integer.parseInt(stringArray2[0]));
                    numericRange.setEnd(i2, Integer.parseInt(stringArray2[1]));
                    if (numericRange.getBegin(i2) != numericRange.getEnd(i2)) continue;
                    throw new IllegalArgumentException("Begin = End");
                }
                numericRange.setBegin(i2, Integer.parseInt(stringArray2[0]));
                continue;
            }
            catch (Exception exception) {
                throw new ServiceResultException(StatusCodes.Bad_IndexRangeInvalid, (Throwable)exception, "Cannot parse numeric range: " + string + ".");
            }
        }
        return numericRange;
    }

    public static String toString(NumericRange numericRange) {
        return numericRange == null ? null : numericRange.toString();
    }

    public NumericRange() {
        this.init(1);
    }

    public NumericRange(int n2) {
        this.a(new int[][]{{n2, -1}});
    }

    public NumericRange(int n2, int n3) {
        this.a(new int[][]{{n2, n3}});
    }

    public NumericRange(int[] ... nArray) {
        this.a(nArray);
    }

    public boolean ensureValid(int n2) {
        if (n2 == -1) {
            return false;
        }
        if (this.Bc[0] > n2 || this.Bd[0] >= n2) {
            return false;
        }
        if (this.Bc[0] < 0) {
            this.Bc[0] = 0;
        }
        if (this.Bd[0] < 0) {
            this.Bd[0] = n2;
        }
        return true;
    }

    public boolean ensureValid(Object object) {
        int n2 = -1;
        try {
            Collection collection = (Collection)object;
            n2 = collection.size();
        }
        catch (Exception exception) {
            try {
                n2 = Array.getLength(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.ensureValid(n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NumericRange)) {
            return false;
        }
        NumericRange numericRange = (NumericRange)object;
        return Arrays.equals(this.Bc, numericRange.Bc) && Arrays.equals(this.Bd, numericRange.Bd);
    }

    public int getBegin() {
        return this.getBegin(0);
    }

    public int getBegin(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Dim");
        }
        if (n2 >= this.getDimensions()) {
            return -1;
        }
        return this.Bc[n2];
    }

    public int getDimensions() {
        return this.Bc.length;
    }

    public int getEnd() {
        return this.getEnd(0);
    }

    public int getEnd(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Dim");
        }
        if (n2 >= this.getDimensions()) {
            return -1;
        }
        return this.Bd[n2] < 0 ? this.Bc[n2] : this.Bd[n2];
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Arrays.hashCode(this.Bc);
        n3 = 31 * n3 + Arrays.hashCode(this.Bd);
        return n3;
    }

    public boolean isEmpty() {
        return this.getDimensions() == 1 && this.getBegin() == -1;
    }

    public boolean isEmpty(int n2) {
        return this.getBegin(n2) == -1;
    }

    public void setBegin(int n2) {
        this.setBegin(1, n2);
    }

    public void setBegin(int n2, int n3) {
        if (n3 < -1) {
            throw new IllegalArgumentException("Begin");
        }
        if (n2 < 0 || n2 >= this.getDimensions()) {
            throw new IllegalArgumentException("Dim");
        }
        int n4 = this.Bd[n2];
        if (n4 != -1 && (n3 > n4 || n3 < 0)) {
            throw new IllegalArgumentException("Begin < End");
        }
        this.Bc[n2] = n3;
    }

    public void setDimensions(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Dimensions must be greater than 0. Was:" + n2);
        }
        if (n2 != this.getDimensions()) {
            this.init(n2);
        }
    }

    public void setEnd(int n2) {
        this.setEnd(1, n2);
    }

    public void setEnd(int n2, int n3) {
        if (n3 < -1) {
            throw new IllegalArgumentException("End");
        }
        if (n2 < 0 || n2 >= this.getDimensions()) {
            throw new IllegalArgumentException("Dim");
        }
        int n4 = this.getBegin(n2);
        if (n3 != -1 && (n4 > n3 || n4 < 0)) {
            throw new IllegalArgumentException("Begin > End");
        }
        this.Bd[n2] = n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.getDimensions(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(",");
            }
            if (this.getBegin(i2) < 0) continue;
            if (this.getEnd(i2) <= this.getBegin(i2)) {
                stringBuilder.append(String.valueOf(this.getBegin(i2)));
                continue;
            }
            stringBuilder.append(String.format(Locale.ROOT, "%d:%d", this.getBegin(i2), this.getEnd(i2)));
        }
        return stringBuilder.toString();
    }

    private void init(int n2) {
        this.Bc = new int[n2];
        this.Bd = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.Bc[i2] = -1;
            this.Bd[i2] = -1;
        }
    }

    private void a(int[] ... nArray) {
        int n2 = nArray.length;
        this.init(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2].length > 0) {
                this.Bc[i2] = nArray[i2][0];
            }
            if (nArray[i2].length <= 1) continue;
            this.Bd[i2] = nArray[i2][1];
        }
    }
}

