/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class StreamUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
            while (readableByteChannel.read(byteBuffer) != -1) {
                byteBuffer.flip();
                writableByteChannel.write(byteBuffer);
                byteBuffer.compact();
            }
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                writableByteChannel.write(byteBuffer);
            }
        }
        finally {
            readableByteChannel.close();
            writableByteChannel.close();
        }
    }

    public static void read(InputStream inputStream, ByteBuffer byteBuffer, int n2) throws IOException {
        while (n2 > 0 & byteBuffer.hasRemaining()) {
            int n3 = inputStream.read(byteBuffer.array(), byteBuffer.position(), n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            byteBuffer.position(byteBuffer.position() + n3);
            n2 -= n3;
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        StreamUtil.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = inputStream.read(byArray, n2, n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    public static void readFully(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            int n2 = inputStream.read(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
            if (n2 < 0) {
                throw new EOFException();
            }
            byteBuffer.position(byteBuffer.position() + n2);
        }
    }
}

