/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils;

import com.prosysopc.ua.stack.utils.StackUtils;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;

public class TimerUtil {
    public static WeakReference<Timer> timer;

    public static synchronized Timer getTimer() {
        Timer timer;
        Timer timer2 = timer = TimerUtil.timer != null ? (Timer)TimerUtil.timer.get() : null;
        if (timer == null) {
            timer = new Timer(StackUtils.UA_TIMER_NAME_PATTERN, true);
            TimerUtil.timer = new WeakReference<Timer>(timer);
        }
        return timer;
    }

    public static TimerTask schedule(final Runnable runnable, final Executor executor, long l2) {
        if (runnable == null || executor == null) {
            throw new IllegalArgumentException("null arg");
        }
        long l3 = l2 - System.currentTimeMillis();
        if (l3 < 1L) {
            l3 = 1L;
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public boolean cancel() {
                boolean bl = super.cancel();
                TimerUtil.purge();
                return bl;
            }

            @Override
            public void run() {
                executor.execute(runnable);
            }
        };
        TimerUtil.getTimer().schedule(timerTask, l3);
        return timerTask;
    }

    public static TimerTask schedule(Timer timer, final Runnable runnable, final Executor executor, long l2) {
        if (runnable == null || executor == null) {
            throw new IllegalArgumentException("null arg");
        }
        long l3 = l2 - System.currentTimeMillis();
        if (l3 < 1L) {
            l3 = 1L;
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public boolean cancel() {
                boolean bl = super.cancel();
                TimerUtil.purge();
                return bl;
            }

            @Override
            public void run() {
                executor.execute(runnable);
            }
        };
        timer.schedule(timerTask, l3);
        return timerTask;
    }

    protected static void purge() {
        Timer timer;
        Timer timer2 = timer = TimerUtil.timer != null ? (Timer)TimerUtil.timer.get() : null;
        if (timer != null) {
            timer.purge();
        }
    }
}

