/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferReadable
implements IBinaryReadable {
    ByteBuffer buf;

    public ByteBufferReadable(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("null");
        }
        this.buf = ByteBuffer.wrap(byArray);
    }

    public ByteBufferReadable(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("null");
        }
        this.buf = byteBuffer;
    }

    @Override
    public byte get() {
        return this.buf.get();
    }

    @Override
    public void get(byte[] byArray) {
        this.buf.get(byArray);
    }

    @Override
    public void get(byte[] byArray, int n2, int n3) {
        this.buf.get(byArray, n2, n3);
    }

    @Override
    public void get(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.buf.get(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.capacity());
        } else {
            byteBuffer.put(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer.hasArray()) {
            this.buf.get(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n2);
            byteBuffer.position(byteBuffer.position() + n2);
        } else {
            int n3 = n2;
            int n4 = this.buf.limit();
            try {
                this.buf.limit(this.buf.position() + n3);
                byteBuffer.put(this.buf);
            }
            finally {
                this.buf.limit(n4);
            }
        }
    }

    @Override
    public double getDouble() {
        return this.buf.getDouble();
    }

    @Override
    public float getFloat() {
        return this.buf.getFloat();
    }

    @Override
    public int getInt() {
        return this.buf.getInt();
    }

    @Override
    public long getLong() {
        return this.buf.getLong();
    }

    @Override
    public short getShort() {
        return this.buf.getShort();
    }

    @Override
    public long limit() {
        return this.buf.limit();
    }

    @Override
    public ByteOrder order() {
        return this.buf.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
    }

    @Override
    public long position() {
        return this.buf.position();
    }

    public void position(int n2) throws IOException {
        this.buf.position(n2);
    }

    public void position(long l2) throws IOException {
        if (l2 >= Integer.MAX_VALUE || l2 < 0L) {
            throw new IllegalArgumentException("index out of range");
        }
        this.buf.position((int)l2);
    }

    public void skip(long l2) throws IOException {
        long l3 = l2 + this.position();
        this.position(l3);
    }
}

