/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryWriteable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferWriteable
implements IBinaryWriteable {
    private final ByteBuffer buf;

    public ByteBufferWriteable(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("null");
        }
        this.buf = byteBuffer;
    }

    @Override
    public void flush() {
    }

    @Override
    public ByteOrder order() {
        return this.buf.order();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        this.buf.order(byteOrder);
    }

    public long position() throws IOException {
        return this.buf.position();
    }

    public void position(long l2) throws IOException {
        if (l2 >= Integer.MAX_VALUE || l2 < 0L) {
            throw new IllegalArgumentException("index out of range");
        }
        this.buf.position((int)l2);
    }

    @Override
    public void put(byte by) {
        this.buf.put(by);
    }

    @Override
    public void put(byte[] byArray) {
        this.buf.put(byArray);
    }

    @Override
    public void put(byte[] byArray, int n2, int n3) {
        this.buf.put(byArray, n2, n3);
    }

    @Override
    public void put(ByteBuffer byteBuffer) {
        this.buf.put(byteBuffer);
    }

    @Override
    public void put(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            this.buf.put(byArray, byteBuffer.arrayOffset() + byteBuffer.position(), n2);
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.buf.put(byteBuffer.get());
            }
        }
    }

    @Override
    public void putDouble(double d2) {
        this.buf.putDouble(d2);
    }

    @Override
    public void putFloat(float f2) {
        this.buf.putFloat(f2);
    }

    @Override
    public void putInt(int n2) {
        this.buf.putInt(n2);
    }

    @Override
    public void putLong(long l2) {
        this.buf.putLong(l2);
    }

    @Override
    public void putShort(short s2) {
        this.buf.putShort(s2);
    }
}

