/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.utils.bytebuffer;

import com.prosysopc.ua.stack.encoding.binary.LittleEndianByteUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.IBinaryReadable;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LittleEndianInputStreamReadable
implements IBinaryReadable {
    private final InputStream is;
    private final long limit;
    private long CU;
    private final byte[] tx = new byte[2];
    private final byte[] ty = new byte[4];
    private final byte[] CD = new byte[8];

    public LittleEndianInputStreamReadable(InputStream inputStream, long l2) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.is = inputStream;
        this.limit = l2;
    }

    @Override
    public byte get() throws IOException {
        return (byte)this.eDg();
    }

    @Override
    public void get(byte[] byArray) throws IOException {
        this.get(byArray, 0, byArray.length);
    }

    @Override
    public void get(byte[] byArray, int n2, int n3) throws IOException {
        while (n3 > 0) {
            int n4 = this.is.read(byArray, n2, n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            this.CU += (long)n4;
            n2 += n4;
            n3 -= n4;
        }
    }

    @Override
    public void get(ByteBuffer byteBuffer) throws IOException {
        while (byteBuffer.hasRemaining()) {
            byteBuffer.put((byte)this.eDg());
        }
    }

    @Override
    public void get(ByteBuffer byteBuffer, int n2) throws IOException {
        byte[] byArray = new byte[n2];
        this.get(byArray, 0, n2);
        byteBuffer.put(byArray);
    }

    @Override
    public double getDouble() throws IOException {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public float getFloat() throws IOException {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public int getInt() throws IOException {
        this.get(this.ty);
        return LittleEndianByteUtils.bytesToInt(this.ty);
    }

    @Override
    public long getLong() throws IOException {
        this.get(this.CD);
        return LittleEndianByteUtils.bytesToLong(this.CD);
    }

    @Override
    public short getShort() throws IOException {
        this.get(this.tx);
        return LittleEndianByteUtils.bytesToShort(this.tx);
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    @Deprecated
    public void order(ByteOrder byteOrder) {
        if (byteOrder != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("This implementation only supports LITTLE_ENDIAN");
        }
    }

    @Override
    public long position() {
        return this.CU;
    }

    public void skip(long l2) throws IOException {
        this.is.skip(l2);
    }

    private int eDg() throws IOException {
        int n2 = this.is.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        ++this.CU;
        return n2 & 0xFF;
    }
}

