/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.gds;

import com.prosysopc.ua.MethodOutputArguments;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ServerOnNetwork;
import com.prosysopc.ua.types.gds.ApplicationRecordDataType;
import com.prosysopc.ua.types.opcua.FolderType;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/GDS/;i=13")
public interface DirectoryType
extends FolderType {
    public static final String APPLICATIONS = "Applications";
    public static final String FIND_APPLICATIONS = "FindApplications";
    public static final String REGISTER_APPLICATION = "RegisterApplication";
    public static final String UPDATE_APPLICATION = "UpdateApplication";
    public static final String UNREGISTER_APPLICATION = "UnregisterApplication";
    public static final String GET_APPLICATION = "GetApplication";
    public static final String QUERY_APPLICATIONS = "QueryApplications";
    public static final String QUERY_SERVERS = "QueryServers";

    @Mandatory
    public FolderType getApplicationsNode();

    @Mandatory
    public UaMethod getFindApplicationsNode();

    public ApplicationRecordDataType[] findApplications(String var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getRegisterApplicationNode();

    public NodeId registerApplication(ApplicationRecordDataType var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getUpdateApplicationNode();

    public void updateApplication(ApplicationRecordDataType var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getUnregisterApplicationNode();

    public void unregisterApplication(NodeId var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getGetApplicationNode();

    public ApplicationRecordDataType getApplication(NodeId var1) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getQueryApplicationsNode();

    public QueryApplicationsMethodOutputs queryApplications(UnsignedInteger var1, UnsignedInteger var2, String var3, String var4, UnsignedInteger var5, String var6, String[] var7) throws StatusException, ServiceException;

    @Mandatory
    public UaMethod getQueryServersNode();

    public QueryServersMethodOutputs queryServers(UnsignedInteger var1, UnsignedInteger var2, String var3, String var4, String var5, String[] var6) throws StatusException, ServiceException;

    public static class QueryServersMethodOutputs
    implements MethodOutputArguments {
        protected DateTime f_lastCounterResetTime;
        protected ServerOnNetwork[] f_servers;

        public QueryServersMethodOutputs(DateTime dateTime, ServerOnNetwork[] serverOnNetworkArray) {
            this.f_lastCounterResetTime = dateTime;
            this.f_servers = serverOnNetworkArray;
        }

        public DateTime getLastCounterResetTime() {
            return this.f_lastCounterResetTime;
        }

        public ServerOnNetwork[] getServers() {
            return this.f_servers;
        }

        @Override
        public final Variant[] asVariantArray() {
            return new Variant[]{new Variant(this.f_lastCounterResetTime), new Variant(this.f_servers)};
        }
    }

    public static class QueryApplicationsMethodOutputs
    implements MethodOutputArguments {
        protected DateTime f_lastCounterResetTime;
        protected UnsignedInteger f_nextRecordId;
        protected ApplicationDescription[] f_applications;

        public QueryApplicationsMethodOutputs(DateTime dateTime, UnsignedInteger unsignedInteger, ApplicationDescription[] applicationDescriptionArray) {
            this.f_lastCounterResetTime = dateTime;
            this.f_nextRecordId = unsignedInteger;
            this.f_applications = applicationDescriptionArray;
        }

        public DateTime getLastCounterResetTime() {
            return this.f_lastCounterResetTime;
        }

        public UnsignedInteger getNextRecordId() {
            return this.f_nextRecordId;
        }

        public ApplicationDescription[] getApplications() {
            return this.f_applications;
        }

        @Override
        public final Variant[] asVariantArray() {
            return new Variant[]{new Variant(this.f_lastCounterResetTime), new Variant(this.f_nextRecordId), new Variant(this.f_applications)};
        }
    }
}

