/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.core.ProgramDiagnostic2DataType;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.FiniteStateMachineType;
import com.prosysopc.ua.types.opcua.FiniteStateVariableType;
import com.prosysopc.ua.types.opcua.FiniteTransitionVariableType;
import com.prosysopc.ua.types.opcua.ProgramDiagnostic2Type;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2391")
public interface ProgramStateMachineType
extends FiniteStateMachineType {
    public static final String DELETABLE = "Deletable";
    public static final String RECYCLE_COUNT = "RecycleCount";
    public static final String AUTO_DELETE = "AutoDelete";
    public static final String FINAL_RESULT_DATA = "FinalResultData";
    public static final String LAST_TRANSITION = "LastTransition";
    public static final String PROGRAM_DIAGNOSTIC = "ProgramDiagnostic";
    public static final String CURRENT_STATE = "CurrentState";
    public static final String SUSPEND = "Suspend";
    public static final String START = "Start";
    public static final String RESET = "Reset";
    public static final String HALT = "Halt";
    public static final String RESUME = "Resume";

    @Mandatory
    public UaProperty getDeletableNode();

    @Mandatory
    public Boolean isDeletable();

    @Mandatory
    public void setDeletable(Boolean var1) throws StatusException;

    @Mandatory
    public UaProperty getRecycleCountNode();

    @Mandatory
    public Integer getRecycleCount();

    @Mandatory
    public void setRecycleCount(Integer var1) throws StatusException;

    @Mandatory
    public UaProperty getAutoDeleteNode();

    @Mandatory
    public Boolean isAutoDelete();

    @Mandatory
    public void setAutoDelete(Boolean var1) throws StatusException;

    @Override
    @Mandatory
    public FiniteTransitionVariableType getLastTransitionNode();

    @Override
    @Mandatory
    public LocalizedText getLastTransition();

    @Override
    @Mandatory
    public void setLastTransition(LocalizedText var1) throws StatusException;

    @Optional
    public ProgramDiagnostic2Type getProgramDiagnosticNode();

    @Optional
    public ProgramDiagnostic2DataType getProgramDiagnostic();

    @Optional
    public void setProgramDiagnostic(ProgramDiagnostic2DataType var1) throws StatusException;

    @Override
    @Mandatory
    public FiniteStateVariableType getCurrentStateNode();

    @Override
    @Mandatory
    public LocalizedText getCurrentState();

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText var1) throws StatusException;

    @Optional
    public BaseObjectType getFinalResultDataNode();

    @Optional
    public UaMethod getSuspendNode();

    public void suspend() throws StatusException, ServiceException;

    @Optional
    public UaMethod getStartNode();

    public void start() throws StatusException, ServiceException;

    @Optional
    public UaMethod getResetNode();

    public void reset() throws StatusException, ServiceException;

    @Optional
    public UaMethod getHaltNode();

    public void halt() throws StatusException, ServiceException;

    @Optional
    public UaMethod getResumeNode();

    public void resume() throws StatusException, ServiceException;
}

