/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.SecurityTokenRequestType;
import com.prosysopc.ua.types.opcua.AuditOpenSecureChannelEventType;
import com.prosysopc.ua.types.opcua.client.AuditChannelEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2060")
public abstract class AuditOpenSecureChannelEventTypeImplBase
extends AuditChannelEventTypeImpl
implements AuditOpenSecureChannelEventType {
    protected AuditOpenSecureChannelEventTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityPolicyUri() {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityPolicyUri(String string) throws StatusException {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getRequestTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public SecurityTokenRequestType getRequestType() {
        UaProperty uaProperty = this.getRequestTypeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (SecurityTokenRequestType)variant.asEnum(SecurityTokenRequestType.class);
    }

    @Override
    @Mandatory
    public void setRequestType(SecurityTokenRequestType securityTokenRequestType) throws StatusException {
        UaProperty uaProperty = this.getRequestTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestType failed, the Optional node does not exist)");
        }
        uaProperty.setValue(securityTokenRequestType);
    }

    @Override
    @Optional
    public UaProperty getCertificateErrorEventIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateErrorEventId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ByteString getCertificateErrorEventId() {
        UaProperty uaProperty = this.getCertificateErrorEventIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Optional
    public void setCertificateErrorEventId(ByteString byteString) throws StatusException {
        UaProperty uaProperty = this.getCertificateErrorEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateErrorEventId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(byteString);
    }

    @Override
    @Mandatory
    public UaProperty getClientCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString getClientCertificate() {
        UaProperty uaProperty = this.getClientCertificateNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString)object;
    }

    @Override
    @Mandatory
    public void setClientCertificate(ByteString byteString) throws StatusException {
        UaProperty uaProperty = this.getClientCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientCertificate failed, the Optional node does not exist)");
        }
        uaProperty.setValue(byteString);
    }

    @Override
    @Mandatory
    public UaProperty getClientCertificateThumbprintNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientCertificateThumbprint");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientCertificateThumbprint() {
        UaProperty uaProperty = this.getClientCertificateThumbprintNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientCertificateThumbprint(String string) throws StatusException {
        UaProperty uaProperty = this.getClientCertificateThumbprintNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientCertificateThumbprint failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getSecurityModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityMode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public MessageSecurityMode getSecurityMode() {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (MessageSecurityMode)variant.asEnum(MessageSecurityMode.class);
    }

    @Override
    @Mandatory
    public void setSecurityMode(MessageSecurityMode messageSecurityMode) throws StatusException {
        UaProperty uaProperty = this.getSecurityModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityMode failed, the Optional node does not exist)");
        }
        uaProperty.setValue(messageSecurityMode);
    }

    @Override
    @Mandatory
    public UaProperty getRequestedLifetimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestedLifetime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getRequestedLifetime() {
        UaProperty uaProperty = this.getRequestedLifetimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setRequestedLifetime(Double d2) throws StatusException {
        UaProperty uaProperty = this.getRequestedLifetimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestedLifetime failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }
}

