/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.client.nodes.UaObjectImpl;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.typedictionary.DynamicEnumeration;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=58")
public class BaseObjectTypeImpl
extends UaObjectImpl
implements BaseObjectType {
    private static final Logger logger = LoggerFactory.getLogger(BaseObjectTypeImpl.class);

    protected BaseObjectTypeImpl(UaNode.Parameters parameters) {
        super(parameters);
    }

    public Object[] callMethod(QualifiedName qualifiedName, Object ... objectArray) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(qualifiedName);
        return this.callMethod(nodeId, objectArray);
    }

    public AsyncResult<Object[]> callMethodAsync(QualifiedName qualifiedName, Object ... objectArray) {
        NodeId nodeId = this.getComponentId(qualifiedName);
        return this.callAsync(nodeId, objectArray);
    }

    @Override
    public QualifiedName getQualifiedName(String string, String string2) {
        return new QualifiedName(this.getAddressSpace().getNamespaceTable().getIndex(string), string2);
    }

    protected NodeId getComponentId(QualifiedName qualifiedName) {
        UaNode uaNode = this.getComponent(qualifiedName);
        if (uaNode == null) {
            throw new IllegalArgumentException("The method node '" + qualifiedName + "' was not found in object '" + this.getBrowseName() + "', NodeId=" + this.getNodeId());
        }
        NodeId nodeId = uaNode.getNodeId();
        return nodeId;
    }

    protected Enumeration getEnumerationFromRawValue(UaVariable uaVariable) {
        Variant variant = uaVariable.getValue().getValue();
        if (variant == null || variant.isEmpty()) {
            return null;
        }
        try {
            int n2 = variant.intValue();
            NodeId nodeId = uaVariable.getDataTypeId();
            NamespaceTable namespaceTable = this.getAddressSpace().getNamespaceTable();
            EnumerationSpecification enumerationSpecification = this.getAddressSpace().getEncoderContext().getEnumerationSpecification(UaNodeId.fromLocal(nodeId, namespaceTable));
            if (enumerationSpecification != null) {
                return enumerationSpecification.getByValue(n2);
            }
            return DynamicEnumeration.valueOf(n2);
        }
        catch (Exception exception) {
            logger.error("Could not resolve Variant {} to Enumeration", (Object)variant, (Object)exception);
            return null;
        }
    }
}

