/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodArgumentTransformer;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.types.opcua.KeyCredentialConfigurationType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18001")
public abstract class KeyCredentialConfigurationTypeImplBase
extends BaseObjectTypeImpl
implements KeyCredentialConfigurationType {
    protected KeyCredentialConfigurationTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getResourceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResourceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getResourceUri() {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setResourceUri(String string) throws StatusException {
        UaProperty uaProperty = this.getResourceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResourceUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getProfileUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProfileUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProfileUri() {
        UaProperty uaProperty = this.getProfileUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProfileUri(String string) throws StatusException {
        UaProperty uaProperty = this.getProfileUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ProfileUri failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getCredentialIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CredentialId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getCredentialId() {
        UaProperty uaProperty = this.getCredentialIdNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setCredentialId(String string) throws StatusException {
        UaProperty uaProperty = this.getCredentialIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CredentialId failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getServiceStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServiceStatus");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public StatusCode getServiceStatus() {
        UaProperty uaProperty = this.getServiceStatusNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Optional
    public void setServiceStatus(StatusCode statusCode) throws StatusException {
        UaProperty uaProperty = this.getServiceStatusNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceStatus failed, the Optional node does not exist)");
        }
        uaProperty.setValue(statusCode);
    }

    @Override
    @Optional
    public UaProperty getEndpointUrlsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointUrls");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String[] getEndpointUrls() {
        UaProperty uaProperty = this.getEndpointUrlsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Optional
    public void setEndpointUrls(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getEndpointUrlsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndpointUrls failed, the Optional node does not exist)");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Optional
    public UaMethod getDeleteCredentialNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteCredential");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void deleteCredential() throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteCredential"));
        this.call(nodeId, new Object[0]);
    }

    public AsyncResult<Void> deleteCredentialAsync() {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "DeleteCredential"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, new Object[0]);
    }

    @Override
    @Optional
    public UaMethod getUpdateCredentialNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCredential");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public void updateCredential(String string, ByteString byteString, String string2, String string3) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCredential"));
        this.call(nodeId, string, byteString, string2, string3);
    }

    public AsyncResult<Void> updateCredentialAsync(String string, ByteString byteString, String string2, String string3) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCredential"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<Void>(){

            public Void i(Variant[] variantArray) {
                return null;
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.i(variantArray);
            }
        }, string, byteString, string2, string3);
    }

    @Override
    @Optional
    public UaMethod getGetEncryptingKeyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetEncryptingKey");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public KeyCredentialConfigurationType.GetEncryptingKeyMethodOutputs getEncryptingKey(String string, String string2) throws MethodCallStatusException, ServiceException {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "GetEncryptingKey"));
        return this.call(nodeId, new MethodArgumentTransformer<KeyCredentialConfigurationType.GetEncryptingKeyMethodOutputs>(){

            public KeyCredentialConfigurationType.GetEncryptingKeyMethodOutputs z(Variant[] variantArray) {
                return new KeyCredentialConfigurationType.GetEncryptingKeyMethodOutputs((ByteString)variantArray[0].getValue(), (String)variantArray[1].getValue());
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.z(variantArray);
            }
        }, string, string2);
    }

    public AsyncResult<? extends KeyCredentialConfigurationType.GetEncryptingKeyMethodOutputs> getEncryptingKeyAsync(String string, String string2) {
        NodeId nodeId = this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "GetEncryptingKey"));
        return this.callAsync(nodeId, new MethodArgumentTransformer<KeyCredentialConfigurationType.GetEncryptingKeyMethodOutputs>(){

            public KeyCredentialConfigurationType.GetEncryptingKeyMethodOutputs z(Variant[] variantArray) {
                return new KeyCredentialConfigurationType.GetEncryptingKeyMethodOutputs((ByteString)variantArray[0].getValue(), (String)variantArray[1].getValue());
            }

            @Override
            public /* synthetic */ Object fromVariantArray(Variant[] variantArray) {
                return this.z(variantArray);
            }
        }, string, string2);
    }
}

