/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.FiniteTransitionVariableType;
import com.prosysopc.ua.types.opcua.ProgramTransitionAuditEventType;
import com.prosysopc.ua.types.opcua.client.AuditUpdateStateEventTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=3806")
public abstract class ProgramTransitionAuditEventTypeImplBase
extends AuditUpdateStateEventTypeImpl
implements ProgramTransitionAuditEventType {
    protected ProgramTransitionAuditEventTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public FiniteTransitionVariableType getTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Transition");
        return (FiniteTransitionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTransition() {
        FiniteTransitionVariableType finiteTransitionVariableType = this.getTransitionNode();
        if (finiteTransitionVariableType == null) {
            return null;
        }
        Object object = finiteTransitionVariableType.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTransition(LocalizedText localizedText) throws StatusException {
        FiniteTransitionVariableType finiteTransitionVariableType = this.getTransitionNode();
        if (finiteTransitionVariableType == null) {
            throw new RuntimeException("Setting Transition failed, the Optional node does not exist)");
        }
        finiteTransitionVariableType.setValue(localizedText);
    }
}

