/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.AnnotationDataType;
import com.prosysopc.ua.stack.core.QuantityDimension;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.QuantityType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32475")
public abstract class QuantityTypeImplBase
extends BaseObjectTypeImpl
implements QuantityType {
    protected QuantityTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Optional
    public UaProperty getSymbolNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Symbol");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getSymbol() {
        UaProperty uaProperty = this.getSymbolNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setSymbol(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getSymbolNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Symbol failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getDimensionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Dimension");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public QuantityDimension getDimension() {
        UaProperty uaProperty = this.getDimensionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (QuantityDimension)object;
    }

    @Override
    @Mandatory
    public void setDimension(QuantityDimension quantityDimension) throws StatusException {
        UaProperty uaProperty = this.getDimensionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Dimension failed, the Optional node does not exist)");
        }
        uaProperty.setValue(quantityDimension);
    }

    @Override
    @Optional
    public UaProperty getAnnotationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Annotation");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public AnnotationDataType[] getAnnotation() {
        UaProperty uaProperty = this.getAnnotationNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (AnnotationDataType[])object;
    }

    @Override
    @Optional
    public void setAnnotation(AnnotationDataType[] annotationDataTypeArray) throws StatusException {
        UaProperty uaProperty = this.getAnnotationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Annotation failed, the Optional node does not exist)");
        }
        uaProperty.setValue(annotationDataTypeArray);
    }

    @Override
    @Optional
    public UaProperty getConversionServiceNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConversionService");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getConversionService() {
        UaProperty uaProperty = this.getConversionServiceNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setConversionService(String string) throws StatusException {
        UaProperty uaProperty = this.getConversionServiceNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConversionService failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public BaseObjectType getServerUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerUnits");
        return (BaseObjectType)this.getComponent(qualifiedName);
    }
}

