/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.RedundancySupport;
import com.prosysopc.ua.stack.core.RedundantServerDataType;
import com.prosysopc.ua.types.opcua.ServerRedundancyType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2034")
public abstract class ServerRedundancyTypeImplBase
extends BaseObjectTypeImpl
implements ServerRedundancyType {
    protected ServerRedundancyTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getRedundancySupportNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RedundancySupport");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public RedundancySupport getRedundancySupport() {
        UaProperty uaProperty = this.getRedundancySupportNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (RedundancySupport)variant.asEnum(RedundancySupport.class);
    }

    @Override
    @Mandatory
    public void setRedundancySupport(RedundancySupport redundancySupport) throws StatusException {
        UaProperty uaProperty = this.getRedundancySupportNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RedundancySupport failed, the Optional node does not exist)");
        }
        uaProperty.setValue(redundancySupport);
    }

    @Override
    @Optional
    public UaProperty getRedundantServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RedundantServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public RedundantServerDataType[] getRedundantServerArray() {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (RedundantServerDataType[])object;
    }

    @Override
    @Optional
    public void setRedundantServerArray(RedundantServerDataType[] redundantServerDataTypeArray) throws StatusException {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RedundantServerArray failed, the Optional node does not exist)");
        }
        uaProperty.setValue(redundantServerDataTypeArray);
    }
}

