/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DataSetOrderingType;
import com.prosysopc.ua.stack.core.UadpNetworkMessageContentMask;
import com.prosysopc.ua.types.opcua.UadpWriterGroupMessageType;
import com.prosysopc.ua.types.opcua.client.WriterGroupMessageTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21105")
public abstract class UadpWriterGroupMessageTypeImplBase
extends WriterGroupMessageTypeImpl
implements UadpWriterGroupMessageType {
    protected UadpWriterGroupMessageTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getDataSetOrderingNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetOrdering");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetOrderingType getDataSetOrdering() {
        UaProperty uaProperty = this.getDataSetOrderingNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (DataSetOrderingType)variant.asEnum(DataSetOrderingType.class);
    }

    @Override
    @Mandatory
    public void setDataSetOrdering(DataSetOrderingType dataSetOrderingType) throws StatusException {
        UaProperty uaProperty = this.getDataSetOrderingNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetOrdering failed, the Optional node does not exist)");
        }
        uaProperty.setValue(dataSetOrderingType);
    }

    @Override
    @Mandatory
    public UaProperty getGroupVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GroupVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getGroupVersion() {
        UaProperty uaProperty = this.getGroupVersionNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setGroupVersion(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getGroupVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting GroupVersion failed, the Optional node does not exist)");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getSamplingOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SamplingOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getSamplingOffset() {
        UaProperty uaProperty = this.getSamplingOffsetNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setSamplingOffset(Double d2) throws StatusException {
        UaProperty uaProperty = this.getSamplingOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SamplingOffset failed, the Optional node does not exist)");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Mandatory
    public UaProperty getNetworkMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UadpNetworkMessageContentMask getNetworkMessageContentMask() {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UadpNetworkMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setNetworkMessageContentMask(UadpNetworkMessageContentMask uadpNetworkMessageContentMask) throws StatusException {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed, the Optional node does not exist)");
        }
        uaProperty.setValue(uadpNetworkMessageContentMask);
    }

    @Override
    @Mandatory
    public UaProperty getPublishingOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishingOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double[] getPublishingOffset() {
        UaProperty uaProperty = this.getPublishingOffsetNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double[])object;
    }

    @Override
    @Mandatory
    public void setPublishingOffset(Double[] doubleArray) throws StatusException {
        UaProperty uaProperty = this.getPublishingOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PublishingOffset failed, the Optional node does not exist)");
        }
        uaProperty.setValue(doubleArray);
    }
}

