/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.UnitType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32442")
public abstract class UnitTypeImplBase
extends BaseObjectTypeImpl
implements UnitType {
    protected UnitTypeImplBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    @Mandatory
    public UaProperty getUnitSystemNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnitSystem");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getUnitSystem() {
        UaProperty uaProperty = this.getUnitSystemNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setUnitSystem(String string) throws StatusException {
        UaProperty uaProperty = this.getUnitSystemNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UnitSystem failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getDisciplineNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Discipline");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDiscipline() {
        UaProperty uaProperty = this.getDisciplineNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDiscipline(String string) throws StatusException {
        UaProperty uaProperty = this.getDisciplineNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Discipline failed, the Optional node does not exist)");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getSymbolNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Symbol");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getSymbol() {
        UaProperty uaProperty = this.getSymbolNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setSymbol(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getSymbolNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Symbol failed, the Optional node does not exist)");
        }
        uaProperty.setValue(localizedText);
    }
}

