/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditHistoryBulkInsertEventType;
import com.prosysopc.ua.types.opcua.server.AuditEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditHistoryBulkInsertEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32803")
public abstract class AuditHistoryBulkInsertEventTypeNodeBase
extends AuditEventTypeNode
implements AuditHistoryBulkInsertEventType {
    private static GeneratedNodeInitializer<AuditHistoryBulkInsertEventTypeNode> Ha;

    protected AuditHistoryBulkInsertEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditHistoryBulkInsertEventTypeNode> generatedNodeInitializer = AuditHistoryBulkInsertEventTypeNodeBase.getAuditHistoryBulkInsertEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditHistoryBulkInsertEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditHistoryBulkInsertEventTypeNode> getAuditHistoryBulkInsertEventTypeNodeInitializer() {
        return Ha;
    }

    public static void setAuditHistoryBulkInsertEventTypeNodeInitializer(GeneratedNodeInitializer<AuditHistoryBulkInsertEventTypeNode> generatedNodeInitializer) {
        Ha = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getEndTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getEndTime() {
        UaProperty uaProperty = this.getEndTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EndTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setEndTime(DateTime dateTime) {
        UaProperty uaProperty = this.getEndTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EndTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getStartTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getStartTime() {
        UaProperty uaProperty = this.getStartTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node StartTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setStartTime(DateTime dateTime) {
        UaProperty uaProperty = this.getStartTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StartTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getUpdatedNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdatedNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getUpdatedNode() {
        UaProperty uaProperty = this.getUpdatedNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UpdatedNode does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setUpdatedNode(NodeId nodeId) {
        UaProperty uaProperty = this.getUpdatedNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UpdatedNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UpdatedNode failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

