/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditHistoryUpdateEventType;
import com.prosysopc.ua.types.opcua.server.AuditHistoryUpdateEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditUpdateEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2104")
public abstract class AuditHistoryUpdateEventTypeNodeBase
extends AuditUpdateEventTypeNode
implements AuditHistoryUpdateEventType {
    private static GeneratedNodeInitializer<AuditHistoryUpdateEventTypeNode> Hg;

    protected AuditHistoryUpdateEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditHistoryUpdateEventTypeNode> generatedNodeInitializer = AuditHistoryUpdateEventTypeNodeBase.getAuditHistoryUpdateEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditHistoryUpdateEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditHistoryUpdateEventTypeNode> getAuditHistoryUpdateEventTypeNodeInitializer() {
        return Hg;
    }

    public static void setAuditHistoryUpdateEventTypeNodeInitializer(GeneratedNodeInitializer<AuditHistoryUpdateEventTypeNode> generatedNodeInitializer) {
        Hg = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getParameterDataTypeIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ParameterDataTypeId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getParameterDataTypeId() {
        UaProperty uaProperty = this.getParameterDataTypeIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ParameterDataTypeId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setParameterDataTypeId(NodeId nodeId) {
        UaProperty uaProperty = this.getParameterDataTypeIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ParameterDataTypeId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ParameterDataTypeId failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

