/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.core.EUInformation;
import com.prosysopc.ua.stack.core.Range;
import com.prosysopc.ua.types.opcua.BaseAnalogType;
import com.prosysopc.ua.types.opcua.server.BaseAnalogTypeNode;
import com.prosysopc.ua.types.opcua.server.DataItemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15318")
public abstract class BaseAnalogTypeNodeBase
extends DataItemTypeNode
implements BaseAnalogType {
    private static GeneratedNodeInitializer<BaseAnalogTypeNode> Hu;

    protected BaseAnalogTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<BaseAnalogTypeNode> generatedNodeInitializer = BaseAnalogTypeNodeBase.getBaseAnalogTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((BaseAnalogTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<BaseAnalogTypeNode> getBaseAnalogTypeNodeInitializer() {
        return Hu;
    }

    public static void setBaseAnalogTypeNodeInitializer(GeneratedNodeInitializer<BaseAnalogTypeNode> generatedNodeInitializer) {
        Hu = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getEngineeringUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EngineeringUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EUInformation getEngineeringUnits() {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Optional
    public void setEngineeringUnits(EUInformation eUInformation) {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EngineeringUnits failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(eUInformation);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EngineeringUnits failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEURangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EURange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Range getEURange() {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Optional
    public void setEURange(Range range) {
        UaProperty uaProperty = this.getEURangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EURange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EURange failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getInstrumentRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InstrumentRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Range getInstrumentRange() {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Optional
    public void setInstrumentRange(Range range) {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InstrumentRange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting InstrumentRange failed unexpectedly", statusException);
        }
    }
}

