/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNodeBase;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2782")
public class ConditionTypeNode
extends ConditionTypeNodeBase {
    protected ConditionTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    public void addComment(ByteString byteString, LocalizedText localizedText, DateTime dateTime, ByteString byteString2) throws StatusException {
        EventData eventData = this.f(byteString);
        eventData.addComment(localizedText);
        this.triggerEvent(dateTime, dateTime, byteString2, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.setQuality(StatusCode.GOOD);
        this.setComment(LocalizedText.EMPTY);
        this.setRetain(false);
        this.afterCreateInitIfExists(this.getEnabledStateNode(), new LocalizedText("Enabled"), new LocalizedText("Disabled"), true);
    }

    public boolean isEnabled() {
        return this.getEnabledStateNode().isId();
    }

    public void setEnabled(boolean bl) {
        this.getEnabledStateNode().setId(bl);
    }

    public void setEnabled(boolean bl, DateTime dateTime) {
        this.getEnabledStateNode().setId(bl, dateTime);
        if (!bl) {
            this.setRetain(false);
        }
    }

    @Override
    public void setQuality(StatusCode statusCode) {
        if (statusCode == null) {
            throw new NullPointerException("quality may not be null");
        }
        super.setQuality(statusCode);
    }

    public void setRetain(boolean bl) {
        super.setRetain(bl);
    }

    @Override
    public ByteString triggerEvent(DateTime dateTime, DateTime dateTime2, ByteString byteString) {
        return this.triggerEvent(dateTime, dateTime2, byteString, null);
    }

    public ByteString triggerEvent(DateTime dateTime, DateTime dateTime2, ByteString byteString, LocalizedText localizedText) {
        this.setComment(localizedText);
        return super.triggerEvent(dateTime, dateTime2, byteString);
    }

    private EventData f(ByteString byteString) throws StatusException {
        EventData eventData = this.getLastEvent();
        if (byteString == null || byteString.equals(eventData.getEventId())) {
            return eventData;
        }
        throw new StatusException(StatusCodes.Bad_EventIdUnknown);
    }

    protected void checkEnabled() throws StatusException {
        if (!this.isEnabled()) {
            throw new StatusException(StatusCodes.Bad_ConditionDisabled);
        }
    }

    @Override
    protected void onAddComment(ServiceContext serviceContext, ByteString byteString, LocalizedText localizedText) throws StatusException {
        this.addComment(byteString, localizedText, null, null);
    }

    @Override
    protected void onDisable(ServiceContext serviceContext) throws StatusException {
        DateTime dateTime = DateTime.currentTime();
        this.setEnabled(false, dateTime);
        this.triggerEvent(dateTime, null, null);
    }

    @Override
    protected void onEnable(ServiceContext serviceContext) throws StatusException {
        this.setEnabled(true, DateTime.currentTime());
    }
}

