/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.IIeeeTsnInterfaceConfigurationType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IIeeeTsnInterfaceConfigurationTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24188")
public abstract class IIeeeTsnInterfaceConfigurationTypeNodeBase
extends BaseInterfaceTypeNode
implements IIeeeTsnInterfaceConfigurationType {
    private static GeneratedNodeInitializer<IIeeeTsnInterfaceConfigurationTypeNode> JV;

    protected IIeeeTsnInterfaceConfigurationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getMacAddressNode());
        this.callAfterCreateIfExists(this.getInterfaceNameNode());
        GeneratedNodeInitializer<IIeeeTsnInterfaceConfigurationTypeNode> generatedNodeInitializer = IIeeeTsnInterfaceConfigurationTypeNodeBase.getIIeeeTsnInterfaceConfigurationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IIeeeTsnInterfaceConfigurationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IIeeeTsnInterfaceConfigurationTypeNode> getIIeeeTsnInterfaceConfigurationTypeNodeInitializer() {
        return JV;
    }

    public static void setIIeeeTsnInterfaceConfigurationTypeNodeInitializer(GeneratedNodeInitializer<IIeeeTsnInterfaceConfigurationTypeNode> generatedNodeInitializer) {
        JV = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getMacAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MacAddress");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getMacAddress() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMacAddressNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node MacAddress does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setMacAddress(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getMacAddressNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting MacAddress failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MacAddress failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getInterfaceNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InterfaceName");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public String getInterfaceName() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getInterfaceNameNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setInterfaceName(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getInterfaceNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting InterfaceName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting InterfaceName failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

