/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.LldpRemoteStatisticsType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.LldpRemoteStatisticsTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=18996")
public abstract class LldpRemoteStatisticsTypeNodeBase
extends BaseObjectTypeNode
implements LldpRemoteStatisticsType {
    private static GeneratedNodeInitializer<LldpRemoteStatisticsTypeNode> Ky;

    protected LldpRemoteStatisticsTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getRemoteDeletesNode());
        this.callAfterCreateIfExists(this.getRemoteInsertsNode());
        this.callAfterCreateIfExists(this.getRemoteDropsNode());
        this.callAfterCreateIfExists(this.getRemoteAgeoutsNode());
        this.callAfterCreateIfExists(this.getLastChangeTimeNode());
        GeneratedNodeInitializer<LldpRemoteStatisticsTypeNode> generatedNodeInitializer = LldpRemoteStatisticsTypeNodeBase.getLldpRemoteStatisticsTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((LldpRemoteStatisticsTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<LldpRemoteStatisticsTypeNode> getLldpRemoteStatisticsTypeNodeInitializer() {
        return Ky;
    }

    public static void setLldpRemoteStatisticsTypeNodeInitializer(GeneratedNodeInitializer<LldpRemoteStatisticsTypeNode> generatedNodeInitializer) {
        Ky = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRemoteDeletesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteDeletes");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRemoteDeletes() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteDeletesNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RemoteDeletes does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRemoteDeletes(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteDeletesNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RemoteDeletes failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RemoteDeletes failed unexpectedly", statusException);
        }
    }

    public void setRemoteDeletes(long l2) {
        this.setRemoteDeletes(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRemoteInsertsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteInserts");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRemoteInserts() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteInsertsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RemoteInserts does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRemoteInserts(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteInsertsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RemoteInserts failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RemoteInserts failed unexpectedly", statusException);
        }
    }

    public void setRemoteInserts(long l2) {
        this.setRemoteInserts(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRemoteDropsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteDrops");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRemoteDrops() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteDropsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RemoteDrops does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRemoteDrops(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteDropsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RemoteDrops failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RemoteDrops failed unexpectedly", statusException);
        }
    }

    public void setRemoteDrops(long l2) {
        this.setRemoteDrops(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRemoteAgeoutsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteAgeouts");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRemoteAgeouts() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteAgeoutsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RemoteAgeouts does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRemoteAgeouts(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteAgeoutsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RemoteAgeouts failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RemoteAgeouts failed unexpectedly", statusException);
        }
    }

    public void setRemoteAgeouts(long l2) {
        this.setRemoteAgeouts(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getLastChangeTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastChangeTime");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getLastChangeTime() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getLastChangeTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node LastChangeTime does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setLastChangeTime(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getLastChangeTimeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting LastChangeTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastChangeTime failed unexpectedly", statusException);
        }
    }

    public void setLastChangeTime(long l2) {
        this.setLastChangeTime(UnsignedInteger.valueOf(l2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

