/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.NetworkAddressUrlType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.NetworkAddressTypeNode;
import com.prosysopc.ua.types.opcua.server.NetworkAddressUrlTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21147")
public abstract class NetworkAddressUrlTypeNodeBase
extends NetworkAddressTypeNode
implements NetworkAddressUrlType {
    private static GeneratedNodeInitializer<NetworkAddressUrlTypeNode> KK;

    protected NetworkAddressUrlTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getUrlNode());
        GeneratedNodeInitializer<NetworkAddressUrlTypeNode> generatedNodeInitializer = NetworkAddressUrlTypeNodeBase.getNetworkAddressUrlTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((NetworkAddressUrlTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<NetworkAddressUrlTypeNode> getNetworkAddressUrlTypeNodeInitializer() {
        return KK;
    }

    public static void setNetworkAddressUrlTypeNodeInitializer(GeneratedNodeInitializer<NetworkAddressUrlTypeNode> generatedNodeInitializer) {
        KK = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getUrlNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Url");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getUrl() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUrlNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node Url does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setUrl(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getUrlNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting Url failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Url failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

