/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.RedundantServerDataType;
import com.prosysopc.ua.stack.core.RedundantServerMode;
import com.prosysopc.ua.types.opcua.NonTransparentBackupRedundancyType;
import com.prosysopc.ua.types.opcua.server.NonTransparentBackupRedundancyTypeFailoverMethod;
import com.prosysopc.ua.types.opcua.server.NonTransparentBackupRedundancyTypeNode;
import com.prosysopc.ua.types.opcua.server.NonTransparentRedundancyTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32411")
public abstract class NonTransparentBackupRedundancyTypeNodeBase
extends NonTransparentRedundancyTypeNode
implements NonTransparentBackupRedundancyType {
    private static GeneratedNodeInitializer<NonTransparentBackupRedundancyTypeNode> KP;
    private static NonTransparentBackupRedundancyTypeFailoverMethod KQ;

    protected NonTransparentBackupRedundancyTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<NonTransparentBackupRedundancyTypeNode> generatedNodeInitializer = NonTransparentBackupRedundancyTypeNodeBase.getNonTransparentBackupRedundancyTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((NonTransparentBackupRedundancyTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<NonTransparentBackupRedundancyTypeNode> getNonTransparentBackupRedundancyTypeNodeInitializer() {
        return KP;
    }

    public static void setNonTransparentBackupRedundancyTypeNodeInitializer(GeneratedNodeInitializer<NonTransparentBackupRedundancyTypeNode> generatedNodeInitializer) {
        KP = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getRedundantServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RedundantServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public RedundantServerDataType[] getRedundantServerArray() {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RedundantServerArray does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (RedundantServerDataType[])object;
    }

    @Override
    @Mandatory
    public void setRedundantServerArray(RedundantServerDataType[] redundantServerDataTypeArray) {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RedundantServerArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(redundantServerDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RedundantServerArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getModeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Mode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public RedundantServerMode getMode() {
        UaProperty uaProperty = this.getModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Mode does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (RedundantServerMode)variant.asEnum(RedundantServerMode.class);
    }

    @Override
    @Mandatory
    public void setMode(RedundantServerMode redundantServerMode) {
        UaProperty uaProperty = this.getModeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Mode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(redundantServerMode);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Mode failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Failover"), nodeId)) {
            this.n(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Mandatory
    public UaMethod getFailoverNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Failover");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onFailover(ServiceContext var1) throws StatusException;

    @Override
    public void failover() throws StatusException {
        this.n(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void n(ServiceContext serviceContext) throws StatusException {
        NonTransparentBackupRedundancyTypeFailoverMethod nonTransparentBackupRedundancyTypeFailoverMethod = NonTransparentBackupRedundancyTypeNodeBase.getFailoverMethodImplementation();
        if (nonTransparentBackupRedundancyTypeFailoverMethod != null) {
            nonTransparentBackupRedundancyTypeFailoverMethod.failover(serviceContext, (NonTransparentBackupRedundancyTypeNode)this);
        } else {
            this.onFailover(serviceContext);
        }
    }

    public static NonTransparentBackupRedundancyTypeFailoverMethod getFailoverMethodImplementation() {
        return KQ;
    }

    public static void setFailoverMethodImplementation(NonTransparentBackupRedundancyTypeFailoverMethod nonTransparentBackupRedundancyTypeFailoverMethod) {
        KQ = nonTransparentBackupRedundancyTypeFailoverMethod;
    }
}

