/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.ProgramTransitionEventType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.ProgramTransitionEventTypeNode;
import com.prosysopc.ua.types.opcua.server.TransitionEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2378")
public abstract class ProgramTransitionEventTypeNodeBase
extends TransitionEventTypeNode
implements ProgramTransitionEventType {
    private static GeneratedNodeInitializer<ProgramTransitionEventTypeNode> Ll;

    protected ProgramTransitionEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getIntermediateResultNode());
        GeneratedNodeInitializer<ProgramTransitionEventTypeNode> generatedNodeInitializer = ProgramTransitionEventTypeNodeBase.getProgramTransitionEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ProgramTransitionEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ProgramTransitionEventTypeNode> getProgramTransitionEventTypeNodeInitializer() {
        return Ll;
    }

    public static void setProgramTransitionEventTypeNodeInitializer(GeneratedNodeInitializer<ProgramTransitionEventTypeNode> generatedNodeInitializer) {
        Ll = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getIntermediateResultNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IntermediateResult");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getIntermediateResult() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getIntermediateResultNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node IntermediateResult does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setIntermediateResult(Object object) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getIntermediateResultNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting IntermediateResult failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(object);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting IntermediateResult failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

