/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DataSetReaderDataType;
import com.prosysopc.ua.types.opcua.ReaderGroupType;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsReaderGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.ReaderGroupMessageTypeNode;
import com.prosysopc.ua.types.opcua.server.ReaderGroupTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.ReaderGroupTypeAddDataSetReaderMethod;
import com.prosysopc.ua.types.opcua.server.ReaderGroupTypeNode;
import com.prosysopc.ua.types.opcua.server.ReaderGroupTypeRemoveDataSetReaderMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=17999")
public abstract class ReaderGroupTypeNodeBase
extends PubSubGroupTypeNode
implements ReaderGroupType {
    private static GeneratedNodeInitializer<ReaderGroupTypeNode> Mq;
    private static ReaderGroupTypeRemoveDataSetReaderMethod Mr;
    private static ReaderGroupTypeAddDataSetReaderMethod Ms;

    protected ReaderGroupTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getDiagnosticsNode());
        this.callAfterCreateIfExists(this.getMessageSettingsNode());
        this.callAfterCreateIfExists(this.getTransportSettingsNode());
        GeneratedNodeInitializer<ReaderGroupTypeNode> generatedNodeInitializer = ReaderGroupTypeNodeBase.getReaderGroupTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ReaderGroupTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ReaderGroupTypeNode> getReaderGroupTypeNodeInitializer() {
        return Mq;
    }

    public static void setReaderGroupTypeNodeInitializer(GeneratedNodeInitializer<ReaderGroupTypeNode> generatedNodeInitializer) {
        Mq = generatedNodeInitializer;
    }

    @Override
    @Optional
    public PubSubDiagnosticsReaderGroupTypeNode getDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Diagnostics");
        return (PubSubDiagnosticsReaderGroupTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public ReaderGroupMessageTypeNode getMessageSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageSettings");
        return (ReaderGroupMessageTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public ReaderGroupTransportTypeNode getTransportSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportSettings");
        return (ReaderGroupTransportTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveDataSetReader"), nodeId)) {
            this.l(serviceContext, (NodeId)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddDataSetReader"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (DataSetReaderDataType)variantArray[0].getValue()))};
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getRemoveDataSetReaderNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveDataSetReader");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveDataSetReader(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public void removeDataSetReader(NodeId nodeId) throws StatusException {
        this.l(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private void l(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        ReaderGroupTypeRemoveDataSetReaderMethod readerGroupTypeRemoveDataSetReaderMethod = ReaderGroupTypeNodeBase.getRemoveDataSetReaderMethodImplementation();
        if (readerGroupTypeRemoveDataSetReaderMethod != null) {
            readerGroupTypeRemoveDataSetReaderMethod.removeDataSetReader(serviceContext, (ReaderGroupTypeNode)this, nodeId);
        } else {
            this.onRemoveDataSetReader(serviceContext, nodeId);
        }
    }

    public static ReaderGroupTypeRemoveDataSetReaderMethod getRemoveDataSetReaderMethodImplementation() {
        return Mr;
    }

    public static void setRemoveDataSetReaderMethodImplementation(ReaderGroupTypeRemoveDataSetReaderMethod readerGroupTypeRemoveDataSetReaderMethod) {
        Mr = readerGroupTypeRemoveDataSetReaderMethod;
    }

    @Override
    @Optional
    public UaMethod getAddDataSetReaderNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddDataSetReader");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onAddDataSetReader(ServiceContext var1, DataSetReaderDataType var2) throws StatusException;

    @Override
    public NodeId addDataSetReader(DataSetReaderDataType dataSetReaderDataType) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, dataSetReaderDataType);
    }

    private NodeId a(ServiceContext serviceContext, DataSetReaderDataType dataSetReaderDataType) throws StatusException {
        ReaderGroupTypeAddDataSetReaderMethod readerGroupTypeAddDataSetReaderMethod = ReaderGroupTypeNodeBase.getAddDataSetReaderMethodImplementation();
        if (readerGroupTypeAddDataSetReaderMethod != null) {
            return readerGroupTypeAddDataSetReaderMethod.addDataSetReader(serviceContext, (ReaderGroupTypeNode)this, dataSetReaderDataType);
        }
        return this.onAddDataSetReader(serviceContext, dataSetReaderDataType);
    }

    public static ReaderGroupTypeAddDataSetReaderMethod getAddDataSetReaderMethodImplementation() {
        return Ms;
    }

    public static void setAddDataSetReaderMethodImplementation(ReaderGroupTypeAddDataSetReaderMethod readerGroupTypeAddDataSetReaderMethod) {
        Ms = readerGroupTypeAddDataSetReaderMethod;
    }
}

