/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.SelectionListType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.SelectionListTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=16309")
public abstract class SelectionListTypeNodeBase
extends BaseDataVariableTypeNode
implements SelectionListType {
    private static GeneratedNodeInitializer<SelectionListTypeNode> MV;

    protected SelectionListTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<SelectionListTypeNode> generatedNodeInitializer = SelectionListTypeNodeBase.getSelectionListTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SelectionListTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SelectionListTypeNode> getSelectionListTypeNodeInitializer() {
        return MV;
    }

    public static void setSelectionListTypeNodeInitializer(GeneratedNodeInitializer<SelectionListTypeNode> generatedNodeInitializer) {
        MV = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getSelectionDescriptionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SelectionDescriptions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText[] getSelectionDescriptions() {
        UaProperty uaProperty = this.getSelectionDescriptionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Optional
    public void setSelectionDescriptions(LocalizedText[] localizedTextArray) {
        UaProperty uaProperty = this.getSelectionDescriptionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SelectionDescriptions failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedTextArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SelectionDescriptions failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getRestrictToListNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RestrictToList");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isRestrictToList() {
        UaProperty uaProperty = this.getRestrictToListNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setRestrictToList(Boolean bl) {
        UaProperty uaProperty = this.getRestrictToListNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RestrictToList failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RestrictToList failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSelectionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Selections");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object[] getSelections() {
        UaProperty uaProperty = this.getSelectionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Selections does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Object[])object;
    }

    @Override
    @Mandatory
    public void setSelections(Object[] objectArray) {
        UaProperty uaProperty = this.getSelectionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Selections failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(objectArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Selections failed unexpectedly", statusException);
        }
    }
}

