/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ConversionLimitEnum;
import com.prosysopc.ua.types.opcua.ServerUnitType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerUnitTypeNode;
import com.prosysopc.ua.types.opcua.server.UnitTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32447")
public abstract class ServerUnitTypeNodeBase
extends UnitTypeNode
implements ServerUnitType {
    private static GeneratedNodeInitializer<ServerUnitTypeNode> Np;

    protected ServerUnitTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getCoherentUnitNode());
        this.callAfterCreateIfExists(this.getAlternativeUnitsNode());
        GeneratedNodeInitializer<ServerUnitTypeNode> generatedNodeInitializer = ServerUnitTypeNodeBase.getServerUnitTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ServerUnitTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ServerUnitTypeNode> getServerUnitTypeNodeInitializer() {
        return Np;
    }

    public static void setServerUnitTypeNodeInitializer(GeneratedNodeInitializer<ServerUnitTypeNode> generatedNodeInitializer) {
        Np = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getConversionLimitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConversionLimit");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ConversionLimitEnum getConversionLimit() {
        UaProperty uaProperty = this.getConversionLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ConversionLimit does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ConversionLimitEnum)variant.asEnum(ConversionLimitEnum.class);
    }

    @Override
    @Mandatory
    public void setConversionLimit(ConversionLimitEnum conversionLimitEnum) {
        UaProperty uaProperty = this.getConversionLimitNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConversionLimit failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(conversionLimitEnum);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConversionLimit failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UnitTypeNode getCoherentUnitNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CoherentUnit");
        return (UnitTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public BaseObjectTypeNode getAlternativeUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AlternativeUnits");
        return (BaseObjectTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

