/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DataSetMetaDataType;
import com.prosysopc.ua.types.opcua.StandaloneSubscribedDataSetType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.StandaloneSubscribedDataSetTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscribedDataSetTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=23828")
public abstract class StandaloneSubscribedDataSetTypeNodeBase
extends BaseObjectTypeNode
implements StandaloneSubscribedDataSetType {
    private static GeneratedNodeInitializer<StandaloneSubscribedDataSetTypeNode> NK;

    protected StandaloneSubscribedDataSetTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSubscribedDataSetNode());
        GeneratedNodeInitializer<StandaloneSubscribedDataSetTypeNode> generatedNodeInitializer = StandaloneSubscribedDataSetTypeNodeBase.getStandaloneSubscribedDataSetTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((StandaloneSubscribedDataSetTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<StandaloneSubscribedDataSetTypeNode> getStandaloneSubscribedDataSetTypeNodeInitializer() {
        return NK;
    }

    public static void setStandaloneSubscribedDataSetTypeNodeInitializer(GeneratedNodeInitializer<StandaloneSubscribedDataSetTypeNode> generatedNodeInitializer) {
        NK = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getIsConnectedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IsConnected");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isIsConnected() {
        UaProperty uaProperty = this.getIsConnectedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node IsConnected does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setIsConnected(Boolean bl) {
        UaProperty uaProperty = this.getIsConnectedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IsConnected failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting IsConnected failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDataSetMetaDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetMetaData");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetMetaDataType getDataSetMetaData() {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetMetaData does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetMetaDataType)object;
    }

    @Override
    @Mandatory
    public void setDataSetMetaData(DataSetMetaDataType dataSetMetaDataType) {
        UaProperty uaProperty = this.getDataSetMetaDataNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetMetaData failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dataSetMetaDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetMetaData failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SubscribedDataSetTypeNode getSubscribedDataSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscribedDataSet");
        return (SubscribedDataSetTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

