/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.StateType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.StateTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2307")
public abstract class StateTypeNodeBase
extends BaseObjectTypeNode
implements StateType {
    private static GeneratedNodeInitializer<StateTypeNode> NM;

    protected StateTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<StateTypeNode> generatedNodeInitializer = StateTypeNodeBase.getStateTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((StateTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<StateTypeNode> getStateTypeNodeInitializer() {
        return NM;
    }

    public static void setStateTypeNodeInitializer(GeneratedNodeInitializer<StateTypeNode> generatedNodeInitializer) {
        NM = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getStateNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StateNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getStateNumber() {
        UaProperty uaProperty = this.getStateNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node StateNumber does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setStateNumber(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getStateNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StateNumber failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting StateNumber failed unexpectedly", statusException);
        }
    }

    public void setStateNumber(long l2) {
        this.setStateNumber(UnsignedInteger.valueOf(l2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

