/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.types.opcua.TransitionVariableType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.TransitionVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2762")
public abstract class TransitionVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements TransitionVariableType {
    private static GeneratedNodeInitializer<TransitionVariableTypeNode> Ov;

    protected TransitionVariableTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<TransitionVariableTypeNode> generatedNodeInitializer = TransitionVariableTypeNodeBase.getTransitionVariableTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TransitionVariableTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TransitionVariableTypeNode> getTransitionVariableTypeNodeInitializer() {
        return Ov;
    }

    public static void setTransitionVariableTypeNodeInitializer(GeneratedNodeInitializer<TransitionVariableTypeNode> generatedNodeInitializer) {
        Ov = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Number");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getNumber() {
        UaProperty uaProperty = this.getNumberNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setNumber(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Number failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Number failed unexpectedly", statusException);
        }
    }

    public void setNumber(long l2) {
        this.setNumber(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getEffectiveTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EffectiveTransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getEffectiveTransitionTime() {
        UaProperty uaProperty = this.getEffectiveTransitionTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setEffectiveTransitionTime(DateTime dateTime) {
        UaProperty uaProperty = this.getEffectiveTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EffectiveTransitionTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EffectiveTransitionTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getTransitionTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransitionTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getTransitionTime() {
        UaProperty uaProperty = this.getTransitionTimeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setTransitionTime(DateTime dateTime) {
        UaProperty uaProperty = this.getTransitionTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransitionTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransitionTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getId() {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Id does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setId(Object object) {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Id failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(object);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Id failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Name");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public QualifiedName getName() {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (QualifiedName)object;
    }

    @Override
    @Optional
    public void setName(QualifiedName qualifiedName) {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Name failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(qualifiedName);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Name failed unexpectedly", statusException);
        }
    }
}

