/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.TrustListOutOfDateAlarmType;
import com.prosysopc.ua.types.opcua.server.SystemOffNormalAlarmTypeNode;
import com.prosysopc.ua.types.opcua.server.TrustListOutOfDateAlarmTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19297")
public abstract class TrustListOutOfDateAlarmTypeNodeBase
extends SystemOffNormalAlarmTypeNode
implements TrustListOutOfDateAlarmType {
    private static GeneratedNodeInitializer<TrustListOutOfDateAlarmTypeNode> Oy;

    protected TrustListOutOfDateAlarmTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<TrustListOutOfDateAlarmTypeNode> generatedNodeInitializer = TrustListOutOfDateAlarmTypeNodeBase.getTrustListOutOfDateAlarmTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TrustListOutOfDateAlarmTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TrustListOutOfDateAlarmTypeNode> getTrustListOutOfDateAlarmTypeNodeInitializer() {
        return Oy;
    }

    public static void setTrustListOutOfDateAlarmTypeNodeInitializer(GeneratedNodeInitializer<TrustListOutOfDateAlarmTypeNode> generatedNodeInitializer) {
        Oy = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getTrustListIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TrustListId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getTrustListId() {
        UaProperty uaProperty = this.getTrustListIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node TrustListId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setTrustListId(NodeId nodeId) {
        UaProperty uaProperty = this.getTrustListIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TrustListId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TrustListId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLastUpdateTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastUpdateTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getLastUpdateTime() {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node LastUpdateTime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setLastUpdateTime(DateTime dateTime) {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastUpdateTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastUpdateTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getUpdateFrequencyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateFrequency");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getUpdateFrequency() {
        UaProperty uaProperty = this.getUpdateFrequencyNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UpdateFrequency does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setUpdateFrequency(Double d2) {
        UaProperty uaProperty = this.getUpdateFrequencyNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UpdateFrequency failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UpdateFrequency failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

