/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DataSetOrderingType;
import com.prosysopc.ua.stack.core.UadpNetworkMessageContentMask;
import com.prosysopc.ua.types.opcua.UadpWriterGroupMessageType;
import com.prosysopc.ua.types.opcua.server.UadpWriterGroupMessageTypeNode;
import com.prosysopc.ua.types.opcua.server.WriterGroupMessageTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=21105")
public abstract class UadpWriterGroupMessageTypeNodeBase
extends WriterGroupMessageTypeNode
implements UadpWriterGroupMessageType {
    private static GeneratedNodeInitializer<UadpWriterGroupMessageTypeNode> OK;

    protected UadpWriterGroupMessageTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<UadpWriterGroupMessageTypeNode> generatedNodeInitializer = UadpWriterGroupMessageTypeNodeBase.getUadpWriterGroupMessageTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((UadpWriterGroupMessageTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<UadpWriterGroupMessageTypeNode> getUadpWriterGroupMessageTypeNodeInitializer() {
        return OK;
    }

    public static void setUadpWriterGroupMessageTypeNodeInitializer(GeneratedNodeInitializer<UadpWriterGroupMessageTypeNode> generatedNodeInitializer) {
        OK = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getDataSetOrderingNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetOrdering");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetOrderingType getDataSetOrdering() {
        UaProperty uaProperty = this.getDataSetOrderingNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetOrdering does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (DataSetOrderingType)variant.asEnum(DataSetOrderingType.class);
    }

    @Override
    @Mandatory
    public void setDataSetOrdering(DataSetOrderingType dataSetOrderingType) {
        UaProperty uaProperty = this.getDataSetOrderingNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetOrdering failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dataSetOrderingType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetOrdering failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getGroupVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GroupVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getGroupVersion() {
        UaProperty uaProperty = this.getGroupVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node GroupVersion does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setGroupVersion(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getGroupVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting GroupVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting GroupVersion failed unexpectedly", statusException);
        }
    }

    public void setGroupVersion(long l2) {
        this.setGroupVersion(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public UaProperty getSamplingOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SamplingOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getSamplingOffset() {
        UaProperty uaProperty = this.getSamplingOffsetNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setSamplingOffset(Double d2) {
        UaProperty uaProperty = this.getSamplingOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SamplingOffset failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SamplingOffset failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getNetworkMessageContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NetworkMessageContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UadpNetworkMessageContentMask getNetworkMessageContentMask() {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node NetworkMessageContentMask does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UadpNetworkMessageContentMask)object;
    }

    @Override
    @Mandatory
    public void setNetworkMessageContentMask(UadpNetworkMessageContentMask uadpNetworkMessageContentMask) {
        UaProperty uaProperty = this.getNetworkMessageContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(uadpNetworkMessageContentMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting NetworkMessageContentMask failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getPublishingOffsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PublishingOffset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double[] getPublishingOffset() {
        UaProperty uaProperty = this.getPublishingOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node PublishingOffset does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double[])object;
    }

    @Override
    @Mandatory
    public void setPublishingOffset(Double[] doubleArray) {
        UaProperty uaProperty = this.getPublishingOffsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting PublishingOffset failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(doubleArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PublishingOffset failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

