/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaCore.util;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public final class OpcUaCoreUtil {
    public static final Version ADDING_ARRAYS_DIRECTLY_FIRST_VERSION = new Version("4.15");
    public static final Version WRITABLE_POINT_FIRST_VERSION = new Version("4.15");
    private static final HashMap<UnsignedInteger, String> statusCodeDescriptionMap = new HashMap();
    private static final String STATUS_CODES_LEXICON_KEY_PREFIX = "opcUaCore.util.statusCodes.";
    private static final Lexicon LEX = Lexicon.make((String)"opcUaCore");
    private static final Logger LOGGER = Logger.getLogger("opcUaCore.util");

    private OpcUaCoreUtil() {
    }

    public static String getLocalizedMessage(Exception e2) {
        String failureMessage;
        if (e2 instanceof ServiceException) {
            StatusCode statusCode = ((ServiceException)e2).getServiceResult();
            failureMessage = e2.getMessage() != null && statusCode != null ? e2.getLocalizedMessage() + " (" + OpcUaCoreUtil.getLocalizedDescription(statusCode) + ')' : (e2.getMessage() != null ? e2.getLocalizedMessage() : (statusCode != null ? OpcUaCoreUtil.getLocalizedDescription(statusCode) : LEX.getText("opcUaCore.util.unexpectedServiceException")));
        } else if (e2 instanceof StatusException) {
            String description = OpcUaCoreUtil.getLocalizedDescription(((StatusException)e2).getStatusCode());
            failureMessage = e2.getMessage() != null && !e2.getMessage().contains(description) ? e2.getLocalizedMessage() + " (" + description + ')' : description;
        } else {
            failureMessage = e2.getLocalizedMessage();
        }
        return failureMessage;
    }

    public static String getLocalizedDescription(StatusCode code) {
        OpcUaCoreUtil.initializeStatusCodesLocalizedDescriptionMap();
        String localizedDescription = statusCodeDescriptionMap.get(code.getValue());
        if (localizedDescription == null) {
            LOGGER.log(Level.FINE, "Localization not supported for Status Code: " + code.getName());
            return code.getDescription();
        }
        return localizedDescription;
    }

    private static void initializeStatusCodesLocalizedDescriptionMap() {
        statusCodeDescriptionMap.put(StatusCodes.Good, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Good)));
        statusCodeDescriptionMap.put(StatusCodes.Bad, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_UnexpectedError, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_UnexpectedError)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_InvalidArgument, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_InvalidArgument)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_InvalidState, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_InvalidState)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_OutOfService, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_OutOfService)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_ServerNotConnected, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_ServerNotConnected)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_UserAccessDenied, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_UserAccessDenied)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_IdentityTokenInvalid, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_IdentityTokenInvalid)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_SubscriptionIdInvalid, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_SubscriptionIdInvalid)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_ConditionBranchAlreadyConfirmed, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_ConditionBranchAlreadyConfirmed)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_EventIdUnknown, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_EventIdUnknown)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_HistoryOperationUnsupported, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_HistoryOperationUnsupported)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_NoData, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_NoData)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_CertificateTimeInvalid, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_CertificateTimeInvalid)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_SecurityChecksFailed, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_SecurityChecksFailed)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_CertificateInvalid, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_CertificateInvalid)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_CertificateUntrusted, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_CertificateUntrusted)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_CertificateUriInvalid, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_CertificateUriInvalid)));
        statusCodeDescriptionMap.put(StatusCodes.Bad_CertificateChainIncomplete, LEX.getText(STATUS_CODES_LEXICON_KEY_PREFIX + StatusCodes.getStatusCodeErrorName(StatusCodes.Bad_CertificateChainIncomplete)));
    }
}

