/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.apache.http.nio.entity.ProducingNHttpEntity;
import org.apache.http.util.Args;

public class NByteArrayEntity
extends AbstractHttpEntity
implements HttpAsyncContentProducer,
ProducingNHttpEntity {
    private final byte[] b;
    private final int off;
    private final int len;
    private final ByteBuffer buf;
    @Deprecated
    protected final byte[] content;
    @Deprecated
    protected final ByteBuffer buffer;

    public NByteArrayEntity(byte[] b2, ContentType contentType) {
        Args.notNull((Object)b2, (String)"Source byte array");
        this.b = b2;
        this.off = 0;
        this.len = b2.length;
        this.buf = ByteBuffer.wrap(b2);
        this.content = b2;
        this.buffer = this.buf;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public NByteArrayEntity(byte[] b2, int off, int len, ContentType contentType) {
        Args.notNull((Object)b2, (String)"Source byte array");
        if (off < 0 || off > b2.length || len < 0 || off + len < 0 || off + len > b2.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b2.length);
        }
        this.b = b2;
        this.off = off;
        this.len = len;
        this.buf = ByteBuffer.wrap(b2, off, len);
        this.content = b2;
        this.buffer = this.buf;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public NByteArrayEntity(byte[] b2) {
        this(b2, null);
    }

    public NByteArrayEntity(byte[] b2, int off, int len) {
        this(b2, off, len, null);
    }

    @Override
    public void close() {
        this.buf.rewind();
    }

    @Override
    @Deprecated
    public void finish() {
        this.close();
    }

    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
        encoder.write(this.buf);
        if (!this.buf.hasRemaining()) {
            encoder.complete();
        }
    }

    public long getContentLength() {
        return this.len;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return false;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    public void writeTo(OutputStream outStream) throws IOException {
        Args.notNull((Object)outStream, (String)"Output stream");
        outStream.write(this.b, this.off, this.len);
        outStream.flush();
    }
}

