/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb;

import com.tridium.fox.sys.NiagaraNetwork;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.SystemDbConnection;
import com.tridium.util.ArrayUtil;
import java.util.HashSet;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="jobName", type="String", defaultValue="System DB Deletion", flags=7)
public class BSystemDbDeleteJob
extends BSimpleJob {
    @Generated
    public static final Property jobName = BSystemDbDeleteJob.newProperty((int)7, (String)"System DB Deletion", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemDbDeleteJob.class);
    private String[] stationNames;
    private BSystemDb systemDb;

    @Generated
    public String getJobName() {
        return this.getString(jobName);
    }

    @Generated
    public void setJobName(String v) {
        this.setString(jobName, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSystemDbDeleteJob() {
    }

    BSystemDbDeleteJob(BSystemDb systemDb, Context cx) {
        this.stationNames = null;
        this.systemDb = systemDb;
        this.setJobName(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("systemDb.deleteAll.jobName"));
    }

    BSystemDbDeleteJob(BSystemDb systemDb, Context cx, String ... stationNames) {
        this.stationNames = stationNames;
        this.systemDb = systemDb;
        this.setJobName(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("systemDb.deleteStation.jobName", new Object[]{ArrayUtil.join((Object[])stationNames, (String)", ")}));
    }

    public void run(Context cx) throws Exception {
        this.log().start(this.getJobName());
        try (SystemDbConnection connection = this.systemDb.makeConnection(cx);){
            long numRemoved;
            HashSet<String> stationsWithNoMatch = new HashSet<String>();
            if (this.stationNames == null) {
                numRemoved = connection.removeAllEntities();
            } else {
                numRemoved = connection.removeStationEntities(this.stationNames);
                if (numRemoved == 0L) {
                    try {
                        NiagaraNetwork network = null;
                        for (String stationName2 : this.stationNames) {
                            if (stationName2.equals(Sys.getStation().getStationName())) continue;
                            if (network == null) {
                                network = (NiagaraNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get((BObject)this, cx);
                            }
                            if (network.getStation(stationName2) != null) continue;
                            stationsWithNoMatch.add(stationName2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.log().endSuccess();
            if (numRemoved >= 0L) {
                this.log().message("systemDb", "systemDb.delete.entitiesRemoved", new String[]{Long.toString(numRemoved)});
            }
            if (!stationsWithNoMatch.isEmpty()) {
                stationsWithNoMatch.forEach(stationName -> this.log().failed("systemDb", "systemDb.delete.noMatchingStation", new String[]{stationName}));
                throw new LocalizableRuntimeException("systemDb", "systemDb.delete.noMatchingStation", new Object[]{ArrayUtil.join((Object[])this.stationNames, (String)", ")});
            }
        }
        catch (LocalizableRuntimeException lre) {
            throw lre;
        }
        catch (Exception e) {
            if (this.stationNames == null) {
                throw new LocalizableRuntimeException("systemDb", "systemDb.deleteAll.failed", (Throwable)e);
            }
            throw new LocalizableRuntimeException("systemDb", "systemDb.deleteStation.failed", new Object[]{ArrayUtil.join((Object[])this.stationNames, (String)", ")}, (Throwable)e);
        }
    }

    public String toString(Context cx) {
        return this.getJobName();
    }
}

