/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp;

import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.BAaPhpStarDevice;
import com.tridium.aaphp.BAaPhpStarDeviceFolder;
import com.tridium.aaphp.datatypes.BAaPhpTerminalJobRecord;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
@NiagaraProperty(name="terminalHistoryCapacity", type="BCapacity", defaultValue="BCapacity.makeByRecordCount(1000)")
public class BAaPhpStarNetwork
extends BAaPhpNetwork {
    @Generated
    public static final Property terminalHistoryCapacity = BAaPhpStarNetwork.newProperty((int)0, (BValue)BCapacity.makeByRecordCount((int)1000), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpStarNetwork.class);
    private BIHistory terminalHistory;

    @Generated
    public BCapacity getTerminalHistoryCapacity() {
        return (BCapacity)this.get(terminalHistoryCapacity);
    }

    @Generated
    public void setTerminalHistoryCapacity(BCapacity v) {
        this.set(terminalHistoryCapacity, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.configureTerminalHistory();
    }

    private void configureTerminalHistory(BHistoryConfig vtermHistoryCfg) {
        if (vtermHistoryCfg.getTimeZone().equals((Object)BTimeZone.NULL)) {
            vtermHistoryCfg.setTimeZone(BTimeZone.getLocal());
        }
        vtermHistoryCfg.setCapacity(this.getTerminalHistoryCapacity());
    }

    private void configureTerminalHistory() {
        BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase historyDatabase = historyService.getDatabase();
        String theStationName = Sys.getStation().getStationName();
        BHistoryId vtermHistoryId = BHistoryId.make((String)theStationName, (String)"vterm");
        try (HistoryDatabaseConnection conn = historyDatabase.getDbConnection(null);){
            if (conn.exists(vtermHistoryId)) {
                this.configureTerminalHistory(historyDatabase.getConfig(vtermHistoryId));
            } else {
                BHistoryConfig vtermCfg = new BHistoryConfig(vtermHistoryId, BAaPhpTerminalJobRecord.TYPE.getTypeSpec());
                this.configureTerminalHistory(vtermCfg);
                conn.createHistory(vtermCfg);
            }
            this.terminalHistory = conn.getHistory(vtermHistoryId);
        }
    }

    @Override
    public Type getDeviceType() {
        return BAaPhpStarDevice.TYPE;
    }

    @Override
    public Type getDeviceFolderType() {
        return BAaPhpStarDeviceFolder.TYPE;
    }

    @Override
    public int translateAddress(int address) {
        if (address < 10) {
            return address + 48;
        }
        return address + 55;
    }

    public BIHistory getTerminalHistory() {
        return this.terminalHistory;
    }

    @Override
    public void changed(Property prop, Context cx) {
        if (this.isRunning() && prop.equals(terminalHistoryCapacity)) {
            this.configureTerminalHistory();
        }
        super.changed(prop, cx);
    }
}

