/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.messages.AaPhpCloseVirtualTerminalRequest;
import com.tridium.aaphp.messages.AaPhpOpenVirtualTerminalRequest;
import com.tridium.aaphp.messages.AaPhpSimpleAckResponse;
import com.tridium.aaphp.messages.AaPhpVirtualTerminalRequest;
import com.tridium.aaphp.messages.AaPhpVirtualTerminalResponse;
import com.tridium.util.EscUtil;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBlob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="resultsFileOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="earlierResultsFileOrd", type="BOrd", defaultValue="BOrd.NULL", flags=1), @NiagaraProperty(name="deviceName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="compareComplete", type="boolean", defaultValue="false", flags=1)})
public class BAaPhpGatherSetupInfoJob
extends BSimpleJob {
    @Generated
    public static final Property resultsFileOrd = BAaPhpGatherSetupInfoJob.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property earlierResultsFileOrd = BAaPhpGatherSetupInfoJob.newProperty((int)1, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property deviceName = BAaPhpGatherSetupInfoJob.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property compareComplete = BAaPhpGatherSetupInfoJob.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpGatherSetupInfoJob.class);
    static final String HEADER_CONST1 = "******************************************************************************\n* Xml Script Checksum = ";
    static final String HEADER_CONST2 = "* NOTE: If the checksum differs in another version of this file then that file\n* was generated using a different set of terminal XML commands.\n******************************************************************************\n";
    private boolean shouldGatherCommand = false;
    private static final String TERMINAL_COMMANDS = "TerminalCommands";
    private static final String KEYSTROKES_COMMAND = "KeyStrokes";
    private static final String REPEAT_ATTRIBUTE = "repeat";
    private static final String SLEEP_COMMAND = "Sleep";
    private static final String GATHER_COMMAND = "Gather";
    private final BAaPhpDevice device;
    private final BAaPhpNetwork network;
    private final String terminalCommandsXmlContents;
    private final PreventDoubleSpacingOutputStream resultsOut;
    private int numXmlElements = 0;
    private int processedXmlElements = 0;

    @Generated
    public BOrd getResultsFileOrd() {
        return (BOrd)this.get(resultsFileOrd);
    }

    @Generated
    public void setResultsFileOrd(BOrd v) {
        this.set(resultsFileOrd, (BValue)v, null);
    }

    @Generated
    public BOrd getEarlierResultsFileOrd() {
        return (BOrd)this.get(earlierResultsFileOrd);
    }

    @Generated
    public void setEarlierResultsFileOrd(BOrd v) {
        this.set(earlierResultsFileOrd, (BValue)v, null);
    }

    @Generated
    public String getDeviceName() {
        return this.getString(deviceName);
    }

    @Generated
    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    @Generated
    public boolean getCompareComplete() {
        return this.getBoolean(compareComplete);
    }

    @Generated
    public void setCompareComplete(boolean v) {
        this.setBoolean(compareComplete, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAaPhpGatherSetupInfoJob() {
        this.device = null;
        this.network = null;
        this.terminalCommandsXmlContents = null;
        this.resultsOut = null;
    }

    public BAaPhpGatherSetupInfoJob(BAaPhpDevice dev, BBlob terminalCommandsXmlBytes, OutputStream resultsOut, BOrd resultsFileOrd, BOrd earlierResultsFileOrd) {
        this.device = dev;
        this.network = dev.getAaPhpNetwork();
        this.terminalCommandsXmlContents = new String(terminalCommandsXmlBytes.copyBytes());
        this.resultsOut = new PreventDoubleSpacingOutputStream(resultsOut);
        this.setResultsFileOrd(resultsFileOrd);
        this.setEarlierResultsFileOrd(earlierResultsFileOrd);
        this.setDeviceName(dev.getName());
    }

    private void writeHeader() throws Exception {
        CheckedOutputStream cos = new CheckedOutputStream(new ByteArrayOutputStream(), new CRC32());
        cos.write(this.terminalCommandsXmlContents.getBytes());
        this.resultsOut.write(HEADER_CONST1.getBytes());
        this.resultsOut.write(Long.toHexString(cos.getChecksum().getValue()).getBytes());
        this.resultsOut.write(10);
        this.resultsOut.write(HEADER_CONST2.getBytes());
    }

    public void run(Context cx) throws Exception {
        try {
            this.openTerminalSession();
            this.writeHeader();
            this.executeXmlScript();
        }
        finally {
            this.closeTerminalSession();
        }
    }

    private void executeXmlScript() throws OpenSummaryFileException, CloseSummaryFileException, TerminalCommandXmlFormatException, WriteSummaryFileException, OpenTerminalCommandsException, OpenTerminalCommandsParserException, ParseTerminalCommandsParserException {
        block9: {
            try {
                XElem rootCommand = this.getTerminalCommands();
                if (rootCommand == null) {
                    throw new TerminalCommandXmlFormatException("The terminal commands xml file does not seem to be an XML document.", null);
                }
                if (rootCommand.name().equalsIgnoreCase(TERMINAL_COMMANDS)) {
                    this.processRootCommand(rootCommand);
                    break block9;
                }
                throw new TerminalCommandXmlFormatException("The outermost document of the terminal commands xml file must be <TerminalCommands>...</TerminalCommands> not <" + rootCommand.name() + ">...</" + rootCommand.name() + ">", rootCommand);
            }
            finally {
                try {
                    this.log().message("Saving setup info...");
                    this.resultsOut.flush();
                    this.resultsOut.close();
                    this.log().message("Setup info saved.");
                }
                catch (IOException ioe) {
                    throw new CloseSummaryFileException(ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand(XElem terminalCommand) throws TerminalCommandXmlFormatException, WriteSummaryFileException {
        String terminalCommandName = terminalCommand.name();
        try {
            if (terminalCommandName == null) {
                throw new TerminalCommandXmlFormatException("It seems that there is an empty XML tag in the terminal commands xml file.", terminalCommand);
            }
            if (terminalCommandName.equalsIgnoreCase(GATHER_COMMAND)) {
                this.processGatherCommand(terminalCommand);
            } else if (terminalCommandName.equalsIgnoreCase(KEYSTROKES_COMMAND)) {
                this.processKeyStrokesCommand(terminalCommand);
            } else if (terminalCommandName.equalsIgnoreCase(SLEEP_COMMAND)) {
                this.processSleepCommand(terminalCommand);
            } else {
                this.log().message("Ignoring unsupported inner tag from script XML file: <" + terminalCommandName + ">...</" + terminalCommandName + ">");
            }
        }
        finally {
            this.consumeTerminalOuptut(terminalCommand);
            float progress = (float)(++this.processedXmlElements) * 100.0f / (float)this.numXmlElements;
            if (progress > 99.0f) {
                this.progress(99);
            } else {
                this.progress((int)progress);
            }
            if (this.getJobState() == BJobState.canceling) {
                throw new JobCancelException();
            }
        }
    }

    private void processKeyStrokesCommand(XElem keyStrokesCommand) throws WriteSummaryFileException {
        XContent[] content = keyStrokesCommand.content();
        if (content == null || content.length < 1) {
            this.log().message("Ignoring empty <Keystrokes> on line " + keyStrokesCommand.line());
        } else {
            int repeatTimes = keyStrokesCommand.geti(REPEAT_ATTRIBUTE, 1);
            boolean jobLogged = false;
            for (int repeatCount = 0; repeatCount < repeatTimes; ++repeatCount) {
                for (int i = 0; i < content.length; ++i) {
                    if (!(content[i] instanceof XText)) continue;
                    String keystrokes = ((XText)content[i]).string();
                    if (!jobLogged) {
                        jobLogged = true;
                        this.log().message("Sending keystrokes to virtual terminal: " + EscUtil.slot.escape(keystrokes) + (repeatTimes > 1 ? " (" + repeatTimes + " times)" : ""));
                    }
                    this.processKeyStrokes(keystrokes, keyStrokesCommand);
                }
                this.consumeTerminalOuptut(keyStrokesCommand);
            }
        }
    }

    private void processKeyStrokes(String keystrokes, XElem keyStrokesCommand) throws WriteSummaryFileException {
        if (keystrokes != null && keystrokes.length() > 0) {
            this.exchangeTerminalData(keystrokes, keyStrokesCommand);
        }
    }

    private void consumeTerminalOuptut(XElem someElem) throws WriteSummaryFileException {
        String terminalData = this.exchangeTerminalData("", someElem);
        while (terminalData != null && terminalData.length() > 0) {
            terminalData = this.exchangeTerminalData("", someElem);
        }
    }

    private static String stringReplace(String inputString, String oldSubstring, String newSubstring) {
        if (oldSubstring.equals("")) {
            throw new IllegalArgumentException("Old pattern must have content.");
        }
        StringBuilder result = new StringBuilder();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = inputString.indexOf(oldSubstring, startIdx)) >= 0) {
            result.append(inputString.substring(startIdx, idxOld));
            result.append(newSubstring);
            startIdx = idxOld + oldSubstring.length();
        }
        result.append(inputString.substring(startIdx));
        String ret = result.toString();
        while (ret.indexOf(oldSubstring) >= 0) {
            ret = BAaPhpGatherSetupInfoJob.stringReplace(ret, oldSubstring, newSubstring);
        }
        return ret;
    }

    private String exchangeTerminalData(String keyStrokes, XElem keyStrokesCommand) throws WriteSummaryFileException {
        AaPhpVirtualTerminalRequest req = new AaPhpVirtualTerminalRequest(this.network.translateAddress(this.device.getAddress()), keyStrokes);
        AaPhpVirtualTerminalResponse rsp = (AaPhpVirtualTerminalResponse)this.device.getAaPhpNetwork().sendSync(req);
        if (this.getJobState() == BJobState.canceling) {
            throw new JobCancelException();
        }
        if (rsp == null) {
            this.log().message(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":No response from the field device after the driver transmitted \"" + keyStrokes + "\" per your XML command on line " + keyStrokesCommand.line());
        } else if (rsp.isError()) {
            this.log().message(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":The field device reported an error after the driver transmitted \"" + keyStrokes + "\" per your XML command on line " + keyStrokesCommand.line());
        } else {
            if (rsp.isEmpty()) {
                return null;
            }
            String messageText = rsp.getMessageText();
            if (this.shouldGatherCommand) {
                try {
                    this.resultsOut.write(messageText);
                }
                catch (IOException ioe) {
                    throw new WriteSummaryFileException(ioe);
                }
            }
            return messageText;
        }
        return null;
    }

    private void processSleepCommand(XElem sleepCommand) throws TerminalCommandXmlFormatException {
        String sleepText = sleepCommand.string().trim();
        if (sleepText == null) {
            this.log().message("Ignoring empty sleep <Sleep> tag on line " + sleepCommand.line());
        } else {
            try {
                this.log().message("Sleeping for " + sleepText + " milliseconds.");
                int sleepDurationMillis = Integer.parseInt(sleepText);
                Thread.sleep(sleepDurationMillis);
            }
            catch (NumberFormatException nfe) {
                throw new TerminalCommandXmlFormatException("The sleep duration should be a number in milliseconds.", sleepCommand);
            }
            catch (InterruptedException ie) {
                String msg = "Unexpected emergency wakeup from sleep occurred while processing the Sleep tag on line " + sleepCommand.line();
                this.log().message(msg);
                throw new BajaRuntimeException(msg);
            }
        }
    }

    private void processGatherCommand(XElem gatherCommand) throws TerminalCommandXmlFormatException, WriteSummaryFileException {
        this.shouldGatherCommand = true;
        this.log().message("Gather mode on. Gathering virtual terminal output to setup info file.");
        XElem[] children = gatherCommand.elems();
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                this.processCommand(children[i]);
            }
        }
        try {
            Thread.sleep(this.network.getResponseTimeout().getMillis() * 2L);
        }
        catch (InterruptedException ie) {
            throw new JobCancelException("Something just interrupted this job.");
        }
        finally {
            this.shouldGatherCommand = false;
            this.log().message("Gather mode off.");
        }
    }

    private void processRootCommand(XElem rootCommand) throws TerminalCommandXmlFormatException, WriteSummaryFileException {
        XElem[] children = rootCommand.elems();
        if (children == null || children.length < 1) {
            throw new TerminalCommandXmlFormatException("The outermost document of the terminal commands xml file must contain data (one or more <Keystrokes> or <Sleep> tags optionally grouped within a <Log> tag).", rootCommand);
        }
        this.countXmlElements(children);
        for (int i = 0; i < children.length; ++i) {
            this.processCommand(children[i]);
        }
    }

    private void countXmlElements(XElem[] xmlTree) {
        if (xmlTree != null && xmlTree.length > 0) {
            int i = 0;
            while (i < xmlTree.length) {
                this.countXmlElements(xmlTree[i].elems());
                ++i;
                ++this.numXmlElements;
            }
        }
    }

    private XElem getTerminalCommands() throws OpenTerminalCommandsException, OpenTerminalCommandsParserException, ParseTerminalCommandsParserException {
        if (this.terminalCommandsXmlContents != null) {
            XParser terminalCommandsParser;
            try {
                terminalCommandsParser = XParser.make((String)this.terminalCommandsXmlContents);
            }
            catch (Exception e) {
                throw new OpenTerminalCommandsParserException(e);
            }
            try {
                return terminalCommandsParser.parse();
            }
            catch (Exception e) {
                throw new ParseTerminalCommandsParserException(e);
            }
        }
        throw new OpenTerminalCommandsException(new NullPointerException());
    }

    private void openTerminalSession() {
        BRelTime timeout = BRelTime.make((long)(this.network.getResponseTimeout().getMillis() * 3L));
        AaPhpOpenVirtualTerminalRequest req = new AaPhpOpenVirtualTerminalRequest(this.network.translateAddress(this.device.getAddress()));
        AaPhpSimpleAckResponse rsp = (AaPhpSimpleAckResponse)this.network.sendSync(req, timeout, 0);
        if (rsp == null) {
            throw new RuntimeException(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Timeout opening terminal to gather setup info.");
        }
        if (rsp.isError()) {
            throw new RuntimeException(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Error opening terminal to gather setup info:" + rsp.getErrorMsg());
        }
        this.log().message(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Started terminal session to gather setup info");
    }

    private void closeTerminalSession() {
        BRelTime timeout = BRelTime.make((long)(this.network.getResponseTimeout().getMillis() * 4L));
        AaPhpCloseVirtualTerminalRequest req = new AaPhpCloseVirtualTerminalRequest(this.network.translateAddress(this.device.getAddress()));
        AaPhpSimpleAckResponse rsp = (AaPhpSimpleAckResponse)this.network.sendSync(req, timeout, 0);
        if (rsp == null) {
            throw new RuntimeException(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Unable to end terminal session:No response to close terminal command");
        }
        if (rsp.isError()) {
            throw new RuntimeException(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Unable to end terminal session:" + rsp.getErrorMsg());
        }
        this.log().message(this.device.getSlotPath().toString() + ':' + this.device.getAddress() + ":Finished terminal session for gathering setup info.");
    }

    class OpenSummaryFileException
    extends BajaException {
        OpenSummaryFileException(IOException underlyingCause) {
            super((Throwable)underlyingCause);
        }

        public String toString() {
            return "Unable to open output file on target file system:" + this.getCause();
        }
    }

    public static class ParseTerminalCommandsParserException
    extends BajaException {
        ParseTerminalCommandsParserException(Exception underlyingCause) {
            super((Throwable)underlyingCause);
        }

        public String toString() {
            return "Unable to parse terminal commands file:" + this.getCause();
        }
    }

    public static class OpenTerminalCommandsParserException
    extends BajaException {
        OpenTerminalCommandsParserException(Exception underlyingCause) {
            super((Throwable)underlyingCause);
        }

        public String toString() {
            return "Unable to open parser for terminal commands file:" + this.getCause();
        }
    }

    public static class OpenTerminalCommandsException
    extends BajaException {
        OpenTerminalCommandsException(Exception underlyingCause) {
            super((Throwable)underlyingCause);
        }

        public String toString() {
            return "Unable to open terminal commands file:" + this.getCause();
        }
    }

    static class CloseSummaryFileException
    extends BajaException {
        CloseSummaryFileException(IOException underlyingCause) {
            super((Throwable)underlyingCause);
        }

        public String toString() {
            return "Unable to close summary output file on target file system:" + this.getCause();
        }
    }

    static class WriteSummaryFileException
    extends BajaException {
        WriteSummaryFileException(IOException underlyingCause) {
            super((Throwable)underlyingCause);
        }

        public String toString() {
            return "Unable to write to output file on target file system:" + this.getCause();
        }
    }

    public static class TerminalCommandXmlFormatException
    extends BajaException {
        XElem faulty;

        TerminalCommandXmlFormatException(String reason, XElem badTag) {
            super(reason);
            this.faulty = badTag;
        }

        public String toString() {
            if (this.faulty == null) {
                return super.toString();
            }
            return super.toString() + " [ On Line " + this.faulty.line() + "]";
        }
    }

    class PreventDoubleSpacingOutputStream
    extends FilterOutputStream {
        OutputStream out;
        char lastCharPreviouslyWritten;

        PreventDoubleSpacingOutputStream(OutputStream out) {
            super(out);
            this.lastCharPreviouslyWritten = '\u0000';
            this.out = out;
        }

        public void write(String arg) throws IOException {
            arg = BAaPhpGatherSetupInfoJob.stringReplace(arg, "\r\n", "\n");
            arg = BAaPhpGatherSetupInfoJob.stringReplace(arg, "\n\n", "\n");
            char firstChar = (arg = BAaPhpGatherSetupInfoJob.stringReplace(arg, "  ", " ")).charAt(0);
            if (firstChar == '\n' && this.lastCharPreviouslyWritten == '\n' || firstChar == ' ' && this.lastCharPreviouslyWritten == ' ') {
                arg = arg.substring(1);
            }
            this.lastCharPreviouslyWritten = arg.charAt(arg.length() - 1);
            super.write(arg.getBytes());
        }
    }
}

