/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpStarNetwork;
import com.tridium.aaphp.datatypes.BAaPhpLearnStarPointsParam;
import com.tridium.aaphp.datatypes.BAaPhpStarAttribute;
import com.tridium.aaphp.enums.BAaPhpDataTypesEnum;
import com.tridium.aaphp.messages.AaPhpReadAttributeRequest;
import com.tridium.aaphp.messages.AaPhpReadAttributeResponse;
import com.tridium.aaphp.messages.AaPhpReadNextAttributeRequest;
import com.tridium.aaphp.messages.AaPhpReadNextAttributeResponse;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="learnedPoints", type="BFolder", defaultValue="new BFolder()"), @NiagaraProperty(name="discoveryParameters", type="BAaPhpLearnStarPointsParam", defaultValue="new BAaPhpLearnStarPointsParam()")})
@NiagaraTopic(name="learnedEntirePoint", flags=4)
public class BAaPhpLearnStarPointsJob
extends BSimpleJob {
    @Generated
    public static final Property learnedPoints = BAaPhpLearnStarPointsJob.newProperty((int)0, (BValue)new BFolder(), null);
    @Generated
    public static final Property discoveryParameters = BAaPhpLearnStarPointsJob.newProperty((int)0, (BValue)new BAaPhpLearnStarPointsParam(), null);
    @Generated
    public static final Topic learnedEntirePoint = BAaPhpLearnStarPointsJob.newTopic((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpLearnStarPointsJob.class);
    long numPriorGuesses = 0L;
    long prev1 = 0L;
    long prev2 = 0L;
    long prev3 = 0L;
    static final String MSG_KEY = "discovery.update";
    String defaultAttr = "CV";
    static final String BAD_SUBUNIT_NBR = "BadSubunitNumber";
    static final String SUBUNIT_NOT_IN_MAP = "SubunitNotInMap";
    static final String NO_CARD = "NoCard";
    static final String BAD_TYPE = "BadType";
    static final String BAD_CHANNEL = "BadChannel";
    String recycledAaPhpOrd;
    BAaPhpStarAttribute recycledStarAttrib = new BAaPhpStarAttribute();
    BAaPhpStarNetwork aaphpNet;
    BAaPhpDevice aaphpDev;
    int unit;
    int subUnit;
    int fromSubUnit;
    int toSubUnit;
    int nbrSubUnits;
    int nbrPerSubUnit;
    int card;
    int fromCard;
    int toCard;
    int nbrCards;
    int nbrPerCard;
    int channel;
    int fromChannel;
    int toChannel;
    int nbrChannels;
    int nbrPerChannel;
    int subChannel;
    int fromSubChannel;
    int toSubChannel;
    int nbrSubChannels;
    int nbrPerSubChannel;
    BAaPhpDataTypesEnum[] fundamentalTypes;
    int typeId = 0;
    int fromTypeId;
    int toTypeId;
    int nbrTypeIds;
    int nbrPerTypeId;
    int numLearnAttempts = 0;
    int necessaryLearnAttempts;
    long startTick = 0L;

    @Generated
    public BFolder getLearnedPoints() {
        return (BFolder)this.get(learnedPoints);
    }

    @Generated
    public void setLearnedPoints(BFolder v) {
        this.set(learnedPoints, (BValue)v, null);
    }

    @Generated
    public BAaPhpLearnStarPointsParam getDiscoveryParameters() {
        return (BAaPhpLearnStarPointsParam)this.get(discoveryParameters);
    }

    @Generated
    public void setDiscoveryParameters(BAaPhpLearnStarPointsParam v) {
        this.set(discoveryParameters, (BValue)v, null);
    }

    @Generated
    public void fireLearnedEntirePoint(BValue event) {
        this.fire(learnedEntirePoint, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAaPhpLearnStarPointsJob() {
    }

    public BAaPhpLearnStarPointsJob(BAaPhpDevice aaphpDev, BAaPhpLearnStarPointsParam learnPointsParam) {
        this.aaphpDev = aaphpDev;
        this.aaphpNet = (BAaPhpStarNetwork)aaphpDev.getAaPhpNetwork();
        this.unit = this.aaphpNet.translateAddress(aaphpDev.getAddress());
        this.fromSubUnit = learnPointsParam.getFromSubUnit();
        this.toSubUnit = learnPointsParam.getToSubUnit();
        this.fromCard = learnPointsParam.getFromCard();
        this.toCard = learnPointsParam.getToCard();
        this.fromChannel = learnPointsParam.getFromChannel();
        this.toChannel = learnPointsParam.getToChannel();
        this.fromSubChannel = learnPointsParam.getFromSubChannel();
        this.toSubChannel = learnPointsParam.getToSubChannel();
        this.fundamentalTypes = (BAaPhpDataTypesEnum[])learnPointsParam.getFundamentalTypes().getEnumValues().getChildren(BAaPhpDataTypesEnum.class);
        this.fromTypeId = 0;
        this.toTypeId = this.fundamentalTypes.length - 1;
        this.nbrSubChannels = this.toSubChannel - this.fromSubChannel + 1;
        this.nbrChannels = this.toChannel - this.fromChannel + 1;
        this.nbrCards = this.toCard - this.fromCard + 1;
        this.nbrTypeIds = this.toTypeId - this.fromTypeId + 1;
        this.nbrSubUnits = this.toSubUnit - this.fromSubUnit + 1;
        this.nbrPerSubChannel = 1;
        this.nbrPerChannel = this.nbrSubChannels * this.nbrPerSubChannel;
        this.nbrPerCard = this.nbrChannels * this.nbrPerChannel;
        this.nbrPerTypeId = this.nbrCards * this.nbrPerCard;
        this.nbrPerSubUnit = this.nbrTypeIds * this.nbrPerTypeId;
        this.necessaryLearnAttempts = this.nbrSubUnits * this.nbrPerSubUnit;
        this.setDiscoveryParameters(learnPointsParam);
    }

    public void run(Context cx) throws Exception {
        this.logMessage(BAaPhpDevice.LEXICON.getText("discovery.start", new Object[]{this.necessaryLearnAttempts}));
        this.startTick = Clock.ticks();
        this.learnSubUnits();
        this.logMessage(BAaPhpDevice.LEXICON.getText("discovery.complete", new Object[]{BRelTime.toString((long)(Clock.ticks() - this.startTick))}));
    }

    private void learnSubUnits() {
        this.subUnit = this.fromSubUnit;
        while (this.subUnit <= this.toSubUnit) {
            try {
                this.learnDataTypes();
            }
            catch (SubUnitNotInMapException pointsSoFar) {
            }
            catch (BadSubUnitNumberException pointsSoFar) {
            }
            finally {
                int pointsSoFar = (this.subUnit + 1 - this.fromSubUnit) * this.nbrPerSubUnit;
                this.progress((int)((double)pointsSoFar / (double)this.necessaryLearnAttempts * 100.0));
            }
            ++this.subUnit;
        }
    }

    private void learnDataTypes() throws SubUnitNotInMapException, BadSubUnitNumberException {
        this.typeId = this.fromTypeId;
        while (this.typeId <= this.toTypeId) {
            if (this.typeId > this.fromTypeId) {
                this.timedJobMessage();
            }
            this.learnCards();
            ++this.typeId;
        }
    }

    private void learnCards() throws SubUnitNotInMapException, BadSubUnitNumberException {
        this.card = this.fromCard;
        while (this.card <= this.toCard) {
            try {
                this.learnChannels();
            }
            catch (NoCardException noCardException) {
                // empty catch block
            }
            ++this.card;
        }
    }

    private int getPointsSoFar() {
        return (this.subUnit - this.fromSubUnit) * this.nbrPerSubUnit + (this.typeId - this.fromTypeId) * this.nbrPerTypeId + (this.card - this.fromCard) * this.nbrPerCard + (this.channel - this.fromChannel) * this.nbrPerChannel + (this.subChannel - this.fromSubChannel) * this.nbrPerSubChannel;
    }

    private void updateProgress() {
        this.progress((int)((double)this.getPointsSoFar() / (double)this.necessaryLearnAttempts * 100.0));
    }

    private void learnChannels() throws SubUnitNotInMapException, BadSubUnitNumberException, NoCardException {
        this.channel = this.fromChannel;
        while (this.channel <= this.toChannel) {
            this.learnSubChannels();
            ++this.channel;
        }
    }

    private void learnSubChannels() throws SubUnitNotInMapException, BadSubUnitNumberException, NoCardException {
        this.subChannel = this.fromSubChannel;
        while (this.subChannel <= this.toSubChannel) {
            this.updateProgress();
            this.learnPoint();
            ++this.subChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timedJobMessage() {
        long firstGuess;
        double pointsSoFar = this.getPointsSoFar();
        long guess = firstGuess = (long)((double)(Clock.ticks() - this.startTick) / pointsSoFar * ((double)this.necessaryLearnAttempts - pointsSoFar));
        try {
            if (this.numPriorGuesses == 1L) {
                guess = (guess + this.prev1) / 2L;
            } else if (this.numPriorGuesses == 2L) {
                guess = (guess + this.prev1 + this.prev2) / 3L;
            } else if (this.numPriorGuesses >= 3L) {
                guess = (guess + this.prev1 + this.prev2 + this.prev3) / 4L;
            }
            if (this.numPriorGuesses > 2L) {
                Object[] arg = new Object[]{BRelTime.toString((long)guess)};
                String jobMsg = BAaPhpDevice.LEXICON.getText(MSG_KEY, arg);
                this.logMessage(jobMsg);
            }
        }
        finally {
            ++this.numPriorGuesses;
            this.prev3 = this.prev2;
            this.prev2 = this.prev1;
            this.prev1 = firstGuess;
        }
    }

    private void learnPoint() throws SubUnitNotInMapException, BadSubUnitNumberException, NoCardException {
        this.recycledStarAttrib.setSubUnit(this.subUnit);
        this.recycledStarAttrib.setCard(this.card);
        this.recycledStarAttrib.setChannel(this.channel);
        this.recycledStarAttrib.setSubChannel(this.subChannel);
        this.recycledStarAttrib.setFundamentalType(this.fundamentalTypes[this.typeId]);
        this.recycledStarAttrib.setAttr("  ");
        this.learnPoint((BComponent)this.getLearnedPoints());
    }

    private void learnPoint(BComponent parent) throws SubUnitNotInMapException, BadSubUnitNumberException, NoCardException {
        if (this.isAlive()) {
            this.recycledAaPhpOrd = this.recycledStarAttrib.getAaPhpOrd();
            AaPhpReadAttributeRequest req = new AaPhpReadAttributeRequest(this.unit, this.recycledAaPhpOrd);
            AaPhpReadAttributeResponse rsp = (AaPhpReadAttributeResponse)this.aaphpNet.sendSync(req);
            if (rsp != null) {
                if (rsp.isError()) {
                    if (rsp.getErrorMsg().equalsIgnoreCase(SUBUNIT_NOT_IN_MAP)) {
                        throw new SubUnitNotInMapException();
                    }
                    if (rsp.getErrorMsg().equalsIgnoreCase(BAD_SUBUNIT_NBR)) {
                        throw new BadSubUnitNumberException();
                    }
                    if (rsp.getErrorMsg().equalsIgnoreCase(NO_CARD)) {
                        throw new NoCardException();
                    }
                } else {
                    this.processLearnedPoint(parent, rsp);
                }
            }
        } else if (this.getJobState() == BJobState.canceled || this.getJobState() == BJobState.canceling) {
            throw new JobCancelException();
        }
    }

    private void processLearnedPoint(BComponent parent, AaPhpReadAttributeResponse rsp) {
        String learnName = this.recycledStarAttrib.getFundamentalType().getDisplayTag(null) + '_' + Integer.toString(this.recycledStarAttrib.getCard(), 16) + '_' + Integer.toString(this.recycledStarAttrib.getChannel(), 16);
        learnName = learnName + '_' + rsp.getAttributeName();
        learnName = SlotPath.escape((String)learnName);
        BAaPhpStarAttribute learnedPoint = (BAaPhpStarAttribute)this.recycledStarAttrib.newCopy();
        learnedPoint.setRawDataHex(rsp.getRawDataHex());
        learnedPoint.setNumericEncodingType(rsp.getEncodingValue());
        learnedPoint.setAttr(rsp.getAttributeName());
        learnedPoint.setDiscoverValue(rsp.getAttrConv().getStringVal(null));
        parent.add(learnName + '?', (BValue)learnedPoint, 0, rsp.getAttrConv().getDefaultFacets(), null);
        this.heartbeat();
        if (parent instanceof BFolder) {
            this.defaultAttr = rsp.getAttributeName();
            this.learnAttributes(learnedPoint);
        } else if (parent instanceof BAaPhpStarAttribute) {
            this.learnAttributes((BAaPhpStarAttribute)parent);
        } else {
            throw new IllegalArgumentException("The given parent should be been a BFolder or BAaPhpStarAttribute. Please have my program fixed.");
        }
    }

    private void learnAttributes(BAaPhpStarAttribute mainCvAttrib) {
        AaPhpReadNextAttributeRequest req = new AaPhpReadNextAttributeRequest(this.unit, this.recycledAaPhpOrd);
        AaPhpReadNextAttributeResponse rsp = (AaPhpReadNextAttributeResponse)this.aaphpNet.sendSync(req);
        if (rsp != null && !rsp.isError() && rsp.getNextAaPhpOrd() != null) {
            if (!rsp.getAttributeName().equals(this.defaultAttr) && rsp.getAttributeName().trim().length() > 0) {
                this.recycledStarAttrib.setAttr(rsp.getAttributeName());
                this.recycledAaPhpOrd = this.recycledStarAttrib.getAaPhpOrd();
                this.processLearnedPoint(mainCvAttrib, rsp);
            } else {
                this.fireLearnedEntirePoint((BValue)BString.DEFAULT);
            }
        }
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.aaphpNet != null) {
            int severity = this.aaphpNet.getLog().getSeverity();
            this.aaphpNet.getLog().setSeverity(1);
            this.aaphpNet.getLog().message("Learn Star Points Job:" + message);
            this.aaphpNet.getLog().setSeverity(severity);
        }
    }

    class BadChannelException
    extends Exception {
        BadChannelException() {
        }
    }

    class BadTypeException
    extends Exception {
        BadTypeException() {
        }
    }

    class NoCardException
    extends Exception {
        NoCardException() {
        }
    }

    class SubUnitNotInMapException
    extends Exception {
        SubUnitNotInMapException() {
        }
    }

    class BadSubUnitNumberException
    extends Exception {
        BadSubUnitNumberException() {
        }
    }
}

