/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.messages.AaPhpCloseFileRequest;
import com.tridium.aaphp.messages.AaPhpCloseFileResponse;
import com.tridium.aaphp.messages.AaPhpOpenFileRequest;
import com.tridium.aaphp.messages.AaPhpOpenFileResponse;
import com.tridium.aaphp.messages.AaPhpWriteFileRequest;
import com.tridium.aaphp.messages.AaPhpWriteFileResponse;
import com.tridium.aaphp.util.AaPhpOrdParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BBlob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAaPhpWriteFileJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpWriteFileJob.class);
    static final String LEX_SEND_AAPHP_FILE = "sendFile.send.start";
    static final String LEX_SENT_AAPHP_FILE = "sendFile.send.done";
    static final String LEX_SEND_UPDATE = "sendFile.send.update";
    static final String LEX_SEND_FILE_TIMEOUT = "sendFile.send.timeout";
    static final String LEX_SEND_FILE_ERROR = "sendFile.send.aaphpError";
    Object[] lexLogObjectArray = null;
    static final String LEX_AAPHP = "aaphp";
    static final String LEX_OPENING_AAPHP_FILE = "sendFile.open.start";
    static final String LEX_OPENED_AAPHP_FILE = "sendFile.open.done";
    static final String LEX_OPEN_FILE_TIMEOUT = "sendFile.open.timeout";
    static final String LEX_OPEN_FILE_ERROR = "sendFile.open.aaphpError";
    static final String LEX_CLOSING_AAPHP_FILE = "sendFile.close.start";
    static final String LEX_CLOSED_AAPHP_FILE = "sendFile.close.done";
    static final String LEX_CLOSE_FILE_TIMEOUT = "sendFile.close.timeout";
    static final String LEX_CLOSE_FILE_ERROR = "sendFile.close.aaphpError";
    static final String LEX_SEND_COMPLETE = "sendFile.complete";
    static final int RECORD_SIZE = 128;
    final BAaPhpNetwork aaphpNet;
    final byte[] fileData;
    final String aaphpFileOrd;
    final String aaphpFileOrdFriendly;
    final int unitNumberAddress;
    private final int numRecords;
    final char fileNum;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAaPhpWriteFileJob() {
        this.aaphpNet = null;
        this.fileData = null;
        this.aaphpFileOrd = null;
        this.aaphpFileOrdFriendly = null;
        this.unitNumberAddress = Integer.MIN_VALUE;
        this.fileNum = '\u0000';
        this.numRecords = Integer.MIN_VALUE;
    }

    public BAaPhpWriteFileJob(BAaPhpNetwork aaphpNet, int unitNumberAddress, BBlob fileData, String aaphpFileOrd) {
        this.aaphpNet = aaphpNet;
        this.fileData = fileData.copyBytes();
        this.aaphpFileOrd = aaphpFileOrd;
        this.aaphpFileOrdFriendly = new AaPhpOrdParser(aaphpFileOrd).toString();
        this.unitNumberAddress = unitNumberAddress;
        this.fileNum = new AaPhpOrdParser(aaphpFileOrd).getFileNum();
        int numRecords = this.fileData.length / 128;
        if (this.fileData.length % 128 != 0) {
            ++numRecords;
        }
        this.numRecords = numRecords;
    }

    static String dumpToString(byte[] toDump, int from, int to) {
        StringWriter dumpData = new StringWriter();
        ByteArrayUtil.hexDump((PrintWriter)new PrintWriter(dumpData), (byte[])toDump, (int)from, (int)(from - to));
        dumpData.flush();
        return dumpData.toString();
    }

    private void sendRecord(char fileNum, int recNum, int a, int b) {
        AaPhpWriteFileResponse writeRsp = (AaPhpWriteFileResponse)this.aaphpNet.sendSync(new AaPhpWriteFileRequest(this.unitNumberAddress, recNum, fileNum, this.fileData, a, b));
        if (writeRsp == null || writeRsp.isError()) {
            String dumpData = BAaPhpWriteFileJob.dumpToString(this.fileData, a, b);
            if (writeRsp == null) {
                throw BAaPhpWriteFileJob.lexError(LEX_SEND_FILE_TIMEOUT, new Object[]{Integer.toString(recNum), this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress), "\n" + dumpData});
            }
            if (writeRsp.isError()) {
                throw BAaPhpWriteFileJob.lexError(LEX_SEND_FILE_ERROR, new Object[]{Integer.toString(recNum), this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress), "\n" + dumpData});
            }
        }
    }

    private void sendAaPhpFile() {
        this.lexLog(LEX_SEND_AAPHP_FILE);
        long delta = 0L;
        long sumDelta = 0L;
        long avgDelta = 0L;
        long remainingTime = 0L;
        long tick1 = 0L;
        long tick2 = 0L;
        int a = 0;
        int recNum = 0;
        while (a < this.fileData.length) {
            tick1 = Clock.ticks();
            if (recNum > 5) {
                this.logMessage(BAaPhpDevice.LEXICON.getText(LEX_SEND_UPDATE, new Object[]{BRelTime.toString((long)remainingTime)}));
            }
            this.sendRecord(this.fileNum, recNum, a, a + 128);
            this.progress((int)((float)recNum / (float)this.numRecords * 100.0f));
            tick2 = Clock.ticks();
            delta = tick2 - tick1;
            avgDelta = (sumDelta += delta) / (long)(recNum + 1);
            remainingTime = (long)(this.numRecords - recNum) * avgDelta;
            a += 128;
            ++recNum;
        }
        this.lexLog(LEX_SENT_AAPHP_FILE);
    }

    void lexLog(String s) {
        if (this.lexLogObjectArray == null) {
            this.lexLogObjectArray = new Object[]{this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress)};
        }
        this.logMessage(BAaPhpDevice.LEXICON.getText(s, this.lexLogObjectArray));
    }

    static LocalizableRuntimeException lexError(String s) {
        return new LocalizableRuntimeException(LEX_AAPHP, s);
    }

    static LocalizableRuntimeException lexError(String s, Object[] oa) {
        return new LocalizableRuntimeException(LEX_AAPHP, s, oa);
    }

    static LocalizableRuntimeException lexError(String s, Object o1, Object o2) {
        return new LocalizableRuntimeException(LEX_AAPHP, s, new Object[]{o1, o2});
    }

    AaPhpOpenFileResponse openAaPhpFile() {
        this.lexLog(LEX_OPENING_AAPHP_FILE);
        AaPhpOpenFileResponse openRsp = (AaPhpOpenFileResponse)this.aaphpNet.sendSync(new AaPhpOpenFileRequest(this.unitNumberAddress, this.aaphpFileOrd, this.numRecords));
        if (openRsp == null) {
            throw BAaPhpWriteFileJob.lexError(LEX_OPEN_FILE_TIMEOUT, this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress));
        }
        if (openRsp.isError()) {
            throw BAaPhpWriteFileJob.lexError(LEX_OPEN_FILE_ERROR, this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress));
        }
        this.lexLog(LEX_OPENED_AAPHP_FILE);
        this.heartbeat();
        return openRsp;
    }

    void closeAaPhpFile(boolean ignoreError) {
        this.lexLog(LEX_CLOSING_AAPHP_FILE);
        AaPhpCloseFileResponse closeRsp = (AaPhpCloseFileResponse)this.aaphpNet.sendSync(new AaPhpCloseFileRequest(this.unitNumberAddress, this.fileNum));
        if (closeRsp == null) {
            throw BAaPhpWriteFileJob.lexError(LEX_CLOSE_FILE_TIMEOUT, this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress));
        }
        if (closeRsp.isError() && !ignoreError) {
            throw BAaPhpWriteFileJob.lexError(LEX_CLOSE_FILE_ERROR, this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress));
        }
        this.lexLog(LEX_CLOSED_AAPHP_FILE);
        this.heartbeat();
    }

    public void run(Context cx) throws Exception {
        long tick1 = Clock.ticks();
        this.closeAaPhpFile(true);
        this.openAaPhpFile();
        this.sendAaPhpFile();
        this.closeAaPhpFile(false);
        long tick2 = Clock.ticks();
        this.logMessage(BAaPhpDevice.LEXICON.getText(LEX_SEND_COMPLETE, new Object[]{BRelTime.toString((long)(tick2 - tick1))}));
    }

    void logMessage(String message) {
        this.log().message(message);
        if (this.aaphpNet != null) {
            int severity = this.aaphpNet.getLog().getSeverity();
            this.aaphpNet.getLog().setSeverity(1);
            this.aaphpNet.getLog().message("Write File Job:" + message);
            this.aaphpNet.getLog().setSeverity(severity);
        }
    }
}

