/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpMessage;
import com.tridium.aaphp.messages.AaPhpOpenFileResponse;
import com.tridium.aaphp.messages.AaPhpOutputStream;
import com.tridium.aaphp.messages.AaPhpReceivedMessage;
import com.tridium.aaphp.util.AaPhpOrdParser;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.sys.BajaRuntimeException;

public class AaPhpOpenFileRequest
extends AaPhpMessage {
    final AaPhpOrdParser aaphpOrdParser;
    final String aaphpOrd;
    final int minSize;

    public AaPhpOpenFileRequest(int unitNumberAddress, String aaphpFileOrd, int minSize) {
        super(unitNumberAddress);
        this.aaphpOrd = aaphpFileOrd;
        this.aaphpOrdParser = new AaPhpOrdParser(aaphpFileOrd);
        this.minSize = minSize;
    }

    public void write(OutputStream out) {
        AaPhpOutputStream aaphpOutStream = new AaPhpOutputStream();
        aaphpOutStream.write(59);
        aaphpOutStream.write(this.getUnitNumberAddress());
        aaphpOutStream.writeCmdCode("10");
        if (this.aaphpOrdParser.isFileDrive()) {
            aaphpOutStream.write(this.aaphpOrdParser.getDrive());
            aaphpOutStream.writeFName(this.aaphpOrdParser.getFName());
            aaphpOutStream.writeExt(this.aaphpOrdParser.getExt());
        } else if (this.aaphpOrdParser.isFilePath()) {
            aaphpOutStream.write(39);
            aaphpOutStream.writeFilePath(this.aaphpOrdParser.getFilePath());
            aaphpOutStream.write(39);
        } else {
            throw new BajaRuntimeException("Unrecognized aaphp ord:" + this.aaphpOrd);
        }
        aaphpOutStream.writeFileNum(this.aaphpOrdParser.getFileNum());
        aaphpOutStream.writeRawDataHex16(this.minSize);
        aaphpOutStream.writeCrc();
        aaphpOutStream.write(13);
        try {
            out.write(aaphpOutStream.toByteArray());
        }
        catch (IOException ioe) {
            throw new BajaRuntimeException((Throwable)ioe);
        }
    }

    public Message toResponse(ReceivedMessage resp) {
        return new AaPhpOpenFileResponse(this.getUnitNumberAddress(), new AaPhpInputStream(((AaPhpReceivedMessage)resp).getBytes()));
    }
}

