/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.RouterManager;
import com.tridium.lonworks.util.NmUtil;
import java.util.Vector;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

public class NAddressManager
implements AddressManager {
    private static final int SUBNET_NODE_MASK = Short.MAX_VALUE;
    private boolean updateRouterManager = true;
    private RouterManager routerManager = null;
    public static final int MAX_NODEID = 127;
    public static final int FIRST_SUBNET = 1;
    public static final int MAX_SUBNET = 255;
    public static final int DEFAULT_LON_NODE = 0;
    public static final int UNASSIGNED_CHANNEL_ID = 0;
    public static final int FIRST_CHANNEL_ID = 1;
    public static final int MAX_CHANNEL_ID = 65535;
    public static final int DEFAULT_CHANNEL_ID = 1;
    public static final Context localChange = new BasicContext();
    private IntHashMap deviceHash = new IntHashMap(127);
    private int[] subnetMap;
    private Vector<BLonDevice> devVect = new Vector(200);
    private BLocalLonDevice local = null;
    private BLonDevice[] devList = null;
    private boolean staleDeviceList = true;
    private Vector<BLonRouter> rtrVect = new Vector(200);
    private BLonRouter[] rtrList = null;
    private boolean staleRtrList = true;
    private BLonNetwork lon;

    public NAddressManager(BLonNetwork lonworks) {
        this.lon = lonworks;
        this.subnetMap = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.subnetMap[i] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLonDevice(BLonDevice dev) {
        try {
            IntHashMap intHashMap = this.deviceHash;
            synchronized (intHashMap) {
                this.registerAddress(dev.getDeviceData(), (BComponent)dev, 0);
                if (dev.isLocal()) {
                    this.local = (BLocalLonDevice)dev;
                } else {
                    this.devVect.addElement(dev);
                }
                this.staleDeviceList = true;
            }
            this.lon.log().fine("registerLonDevice " + dev.getDisplayName(null) + " " + Integer.toString(dev.getDeviceData().getLastHash(), 16));
            this.lon.fireDeviceChange(null);
            NmUtil.validateNeuronId(dev.getDeviceData().getNeuronId(), (BComponent)dev);
            dev.configOk();
        }
        catch (Throwable e) {
            dev.configFail(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLonDevice(BLonDevice dev) {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            if (dev.isLocal()) {
                this.local = null;
            } else {
                this.devVect.removeElement(dev);
            }
            this.unregisterAddress(dev.getDeviceData());
            this.staleDeviceList = true;
        }
        this.lon.log().fine("unregisterLonDevice " + dev.getDisplayName(null) + " " + Integer.toString(dev.getDeviceData().getLastHash(), 16));
        this.lon.fireDeviceChange(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLonRouter(BLonRouter rtr) {
        try {
            IntHashMap intHashMap = this.deviceHash;
            synchronized (intHashMap) {
                this.registerAddress(rtr.getNearDeviceData(), rtr, 0);
                try {
                    this.registerAddress(rtr.getFarDeviceData(), rtr, 1);
                }
                catch (Throwable e) {
                    this.unregisterAddress(rtr.getNearDeviceData());
                    throw e;
                }
                this.rtrVect.addElement(rtr);
                this.staleRtrList = true;
                this.updateRouterManager = true;
            }
            this.lon.log().fine("registerLonRouter " + rtr.getDisplayName(null) + " " + Integer.toString(rtr.getNearDeviceData().getLastHash(), 16) + " " + Integer.toString(rtr.getFarDeviceData().getLastHash(), 16));
            this.lon.fireDeviceChange(null);
            NmUtil.validateNeuronId(rtr.getNearDeviceData().getNeuronId(), rtr);
            rtr.setStatus(BStatus.ok);
            rtr.setFaultCause("");
        }
        catch (Throwable e) {
            rtr.setStatus(BStatus.fault);
            rtr.setFaultCause(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLonRouter(BLonRouter rtr) {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            this.rtrVect.removeElement((Object)rtr);
            this.unregisterAddress(rtr.getNearDeviceData());
            this.unregisterAddress(rtr.getFarDeviceData());
            this.staleRtrList = true;
            this.updateRouterManager = true;
        }
        this.lon.log().fine("unregisterLonRouter " + rtr.getDisplayName(null) + " " + Integer.toString(rtr.getNearDeviceData().getLastHash(), 16) + " " + Integer.toString(rtr.getFarDeviceData().getLastHash(), 16));
        this.lon.fireDeviceChange(null);
    }

    private void registerAddress(BDeviceData dd, BComponent dev, int delta) throws LonException {
        int hash;
        if (dd.getChannelId() == 0) {
            dd.setInt(BDeviceData.channelId, 1 + delta, noDeviceChange);
        }
        if (((hash = NAddressManager.getDeviceHash(dd)) & Short.MAX_VALUE) == 0) {
            hash = this.claimSubnetNodeId(dd);
        }
        if (!this.verifySubnetChannel(hash)) {
            String msg = dev.getDisplayName(null) + " has invalid subnet " + NAddressManager.getSubnetFromHash(hash) + " for channel " + NAddressManager.getChanIdFromHash(hash) + ". " + dev.getDisplayName(null) + " not registered.";
            this.lon.log().severe(msg);
            throw new LonException(msg);
        }
        BComplex o = (BComplex)this.deviceHash.get(hash);
        if (o != null) {
            if (o == dev) {
                return;
            }
            String msg = "Duplicate nodeId detected with " + o.getDisplayName(null) + ". " + dev.getDisplayName(null) + " not registered. {" + Integer.toString(hash, 16) + "}";
            this.lon.log().severe(msg);
            throw new LonException(msg);
        }
        this.deviceHash.put(hash, (Object)dev);
        dd.setInt(BDeviceData.lastHash, hash, localChange);
    }

    private void unregisterAddress(BDeviceData dd) {
        int hash = dd.getLastHash();
        this.deviceHash.remove(hash);
        this.checkFreeSubnet(hash);
        dd.setInt(BDeviceData.lastHash, -1, localChange);
    }

    @Override
    public void deviceDataChanged(BDeviceData dd, Context context) {
        if (context == localChange) {
            return;
        }
        int lastHash = dd.getLastHash();
        if (lastHash == -1 || lastHash != NAddressManager.getDeviceHash(dd)) {
            BComplex o = dd.getParent();
            if (o instanceof BLonDevice) {
                BLonDevice dev = (BLonDevice)o;
                this.unregisterLonDevice(dev);
                this.registerLonDevice(dev);
            } else if (o instanceof BLonRouter) {
                BLonRouter rtr = (BLonRouter)o;
                this.unregisterLonRouter(rtr);
                this.registerLonRouter(rtr);
            }
        } else {
            this.validateNeuronId(dd);
        }
        if (context != noDeviceChange) {
            this.lon.fireDeviceChange(null);
        }
    }

    private boolean validateNeuronId(BDeviceData dd) {
        BComplex p = dd.getParent();
        String cause = "";
        boolean valid = true;
        try {
            NmUtil.validateNeuronId(dd.getNeuronId(), (BComponent)p);
        }
        catch (LonException e) {
            cause = e.getMessage();
            valid = false;
        }
        if (p instanceof BLonRouter) {
            BLonRouter rtr = (BLonRouter)p;
            if (!valid) {
                rtr.setFaultCause(cause);
                rtr.setStatus(BStatus.make((int)(rtr.getStatus().getBits() | 2)));
            } else if (rtr.getFaultCause().indexOf("NeuronId") >= 0) {
                rtr.setFaultCause("");
                rtr.setStatus(BStatus.make((int)(rtr.getStatus().getBits() & 0xFFFFFFFD)));
            }
        } else if (p instanceof BLonDevice) {
            BLonDevice dev = (BLonDevice)p;
            if (!valid) {
                dev.configFail(cause);
            } else if (dev.getFaultCause().indexOf("NeuronId") >= 0) {
                dev.configOk();
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BString newAddress(BLonDevice dev, int chan, int subnet, int node) {
        BDeviceData dd = dev.getDeviceData();
        int lastHash = dd.getLastHash();
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            if (!this.isValidSubnet(subnet, chan)) {
                if (chan != NAddressManager.getChanIdFromHash(lastHash)) {
                    int h = this.findSubnetNode(chan);
                    subnet = NAddressManager.getSubnetFromHash(h);
                    node = NAddressManager.getNodeFromHash(h);
                } else {
                    return BString.make((String)"Invalid Subnet for channel id.");
                }
            }
            if (!this.isAddressAvailable(subnet, node, chan)) {
                return BString.make((String)("Subnet node " + subnet + "\\" + node + " is already inuse."));
            }
            this.unregisterLonDevice(dev);
            dd.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(subnet, node), localChange);
            dd.setInt(BDeviceData.channelId, chan, localChange);
            if (dev.isConfigured()) {
                dd.set(BDeviceData.nodeState, (BValue)BLonNodeState.unconfigured, localChange);
            }
            this.registerLonDevice(dev);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BString newAddress(BLonRouter rtr, int nearChan, BSubnetNode nearAddr, int farChan, BSubnetNode farAddr) {
        BDeviceData ndd = rtr.getNearDeviceData();
        BDeviceData fdd = rtr.getFarDeviceData();
        int nearSubnet = nearAddr.getSubnetId();
        int nearNode = nearAddr.getNodeId();
        int farSubnet = farAddr.getSubnetId();
        int farNode = farAddr.getNodeId();
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            int h;
            int lastHash;
            if (nearChan == farChan) {
                return BString.make((String)"Near and far channelIds must be different.");
            }
            if (!this.isValidSubnet(nearSubnet, nearChan)) {
                lastHash = ndd.getLastHash();
                if (nearChan != NAddressManager.getChanIdFromHash(lastHash)) {
                    h = this.findSubnetNode(nearChan);
                    nearSubnet = NAddressManager.getSubnetFromHash(h);
                    nearNode = NAddressManager.getNodeFromHash(h);
                } else {
                    return BString.make((String)("Subnet " + nearSubnet + " is invalid  for channel " + nearChan + "."));
                }
            }
            if (!this.isValidSubnet(farSubnet, farChan)) {
                lastHash = fdd.getLastHash();
                if (farChan != NAddressManager.getChanIdFromHash(lastHash)) {
                    h = this.findSubnetNode(farChan);
                    farSubnet = NAddressManager.getSubnetFromHash(h);
                    farNode = NAddressManager.getNodeFromHash(h);
                } else {
                    return BString.make((String)("Subnet " + farSubnet + " is invalid  for channel " + farChan + "."));
                }
            }
            if (!this.isAddressAvailable(nearSubnet, nearNode, nearChan)) {
                return BString.make((String)("Subnet node " + nearSubnet + "\\" + nearNode + " is already inuse."));
            }
            if (!this.isAddressAvailable(farSubnet, farNode, farChan)) {
                return BString.make((String)("Subnet node " + farSubnet + "\\" + farNode + " is already inuse."));
            }
            this.unregisterLonRouter(rtr);
            ndd.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(nearSubnet, nearNode), localChange);
            ndd.setInt(BDeviceData.channelId, nearChan, localChange);
            fdd.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(farSubnet, farNode), localChange);
            fdd.setInt(BDeviceData.channelId, farChan, localChange);
            if (rtr.isConfigured()) {
                ndd.set(BDeviceData.nodeState, (BValue)BLonNodeState.unconfigured, localChange);
                fdd.set(BDeviceData.nodeState, (BValue)BLonNodeState.unconfigured, localChange);
            }
            this.registerLonRouter(rtr);
        }
        return null;
    }

    private boolean isAddressAvailable(int subnet, int node, int chan) {
        int hash = NAddressManager.getDeviceHash(subnet, node, chan);
        Object o = this.deviceHash.get(hash);
        if (o == null) {
            return true;
        }
        if (o instanceof BLonDevice) {
            BLonDevice d = (BLonDevice)o;
            if (d.isConfigured()) {
                return false;
            }
            this.claimSubnetNodeId(d.getDeviceData());
            this.unregisterLonDevice(d);
            this.registerLonDevice(d);
        } else if (o instanceof BLonRouter) {
            BLonRouter r = (BLonRouter)((Object)o);
            if (r.isConfigured()) {
                return false;
            }
            if (r.getNearDeviceData().getLastHash() == hash) {
                this.claimSubnetNodeId(r.getNearDeviceData());
            } else if (r.getFarDeviceData().getLastHash() == hash) {
                this.claimSubnetNodeId(r.getFarDeviceData());
            }
            this.unregisterLonRouter(r);
            this.registerLonRouter(r);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLonDevice[] getDeviceList(boolean includeLocal) {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            BLonDevice[] s = this.makeDeviceList();
            BLonDevice[] d = new BLonDevice[s.length + (includeLocal ? 1 : 0)];
            if (includeLocal) {
                d[0] = this.local;
                System.arraycopy(s, 0, d, 1, s.length);
            } else {
                System.arraycopy(s, 0, d, 0, s.length);
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BLonDevice[] makeDeviceList() {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            if (this.staleDeviceList) {
                this.devList = new BLonDevice[this.devVect.size()];
                this.devVect.copyInto(this.devList);
                this.orderList(this.devList);
                this.staleDeviceList = false;
            }
            return this.devList;
        }
    }

    private void orderList(BLonDevice[] list) {
        int firstNdx = 0;
        int lastNdx = list.length - 1;
        int i = firstNdx;
        while (i < lastNdx) {
            if (NAddressManager.getDeviceHash(list[i]) > NAddressManager.getDeviceHash(list[i + 1])) {
                BLonDevice tmp = list[i];
                list[i] = list[i + 1];
                list[i + 1] = tmp;
                if (i > firstNdx) {
                    --i;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    private void orderList(BLonRouter[] list) {
        int firstNdx = 0;
        int lastNdx = list.length - 1;
        int i = firstNdx;
        while (i < lastNdx) {
            if (NAddressManager.getDeviceHash(list[i].getNearDeviceData()) > NAddressManager.getDeviceHash(list[i + 1].getNearDeviceData())) {
                BLonRouter tmp = list[i];
                list[i] = list[i + 1];
                list[i + 1] = tmp;
                if (i > firstNdx) {
                    --i;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    @Override
    public BLonDevice getDeviceByName(String name) {
        if (this.local != null && this.local.getName().equals(name)) {
            return this.local;
        }
        BLonDevice[] devList = this.makeDeviceList();
        for (int i = 0; i < devList.length; ++i) {
            if (!devList[i].getName().equals(name)) continue;
            return devList[i];
        }
        return null;
    }

    @Override
    public BLonDevice getDeviceByAddress(BSubnetNode addr) {
        if (this.local != null && this.local.getDeviceData().getSubnetNodeId().equals(addr)) {
            return this.local;
        }
        BLonDevice[] devList = this.makeDeviceList();
        for (int i = 0; i < devList.length; ++i) {
            if (!devList[i].getDeviceData().getSubnetNodeId().equals(addr)) continue;
            return devList[i];
        }
        return null;
    }

    @Override
    public BLonDevice getDeviceByAddress(BNeuronId nid) {
        if (this.local != null && this.local.getDeviceData().getNeuronId().equals(nid)) {
            return this.local;
        }
        BLonDevice[] devList = this.makeDeviceList();
        for (int i = 0; i < devList.length; ++i) {
            if (!devList[i].getDeviceData().getNeuronId().equals(nid)) continue;
            return devList[i];
        }
        return null;
    }

    public BLonRouter getRouterByName(String name) {
        BLonRouter[] rtrList = this.makeRouterList();
        for (int i = 0; i < rtrList.length; ++i) {
            if (!rtrList[i].getName().equals(name)) continue;
            return rtrList[i];
        }
        return null;
    }

    @Override
    public BLonRouter getRouterByAddress(BSubnetNode addr) {
        BLonRouter[] rtrList = this.makeRouterList();
        for (int i = 0; i < rtrList.length; ++i) {
            BLonRouter rtr = rtrList[i];
            if (!rtr.getNearDeviceData().getSubnetNodeId().equals(addr) && !rtr.getFarDeviceData().getSubnetNodeId().equals(addr)) continue;
            return rtr;
        }
        return null;
    }

    @Override
    public BLonRouter getRouterByAddress(BNeuronId nid) {
        BLonRouter[] rtrList = this.makeRouterList();
        for (int i = 0; i < rtrList.length; ++i) {
            BLonRouter rtr = rtrList[i];
            if (!rtr.getNearDeviceData().getNeuronId().equals(nid) && !rtr.getFarDeviceData().getNeuronId().equals(nid)) continue;
            return rtr;
        }
        return null;
    }

    @Override
    public BLocalLonDevice getLocalDevice() {
        return this.local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLonRouter[] getRouterList() {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            BLonRouter[] s = this.makeRouterList();
            BLonRouter[] d = new BLonRouter[s.length];
            System.arraycopy(s, 0, d, 0, s.length);
            return d;
        }
    }

    public boolean isRouted() {
        return this.makeRouterList().length > 0;
    }

    protected int[] getSubnetMap() {
        return this.subnetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxChannelId() {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            int maxId = 1;
            for (int i = 0; i < this.subnetMap.length; ++i) {
                if (this.subnetMap[i] <= maxId) continue;
                maxId = this.subnetMap[i];
            }
            return maxId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BLonRouter[] makeRouterList() {
        IntHashMap intHashMap = this.deviceHash;
        synchronized (intHashMap) {
            if (this.staleRtrList) {
                this.rtrList = new BLonRouter[this.rtrVect.size()];
                this.rtrVect.copyInto((Object[])this.rtrList);
                this.orderList(this.rtrList);
                this.staleRtrList = false;
            }
            return this.rtrList;
        }
    }

    private boolean verifySubnetChannel(int hash) {
        int chan;
        int sub = NAddressManager.getSubnetFromHash(hash);
        int s = this.subnetMap[sub];
        if (s == (chan = NAddressManager.getChanIdFromHash(hash))) {
            return true;
        }
        if (s == 0) {
            this.subnetMap[sub] = chan;
            this.updateRouterManager = true;
            return true;
        }
        return false;
    }

    private void checkFreeSubnet(int hash) {
        int sub = NAddressManager.getSubnetFromHash(hash);
        if (this.local != null && this.isAnotherWithSameSubnet(sub, hash, this.local.getDeviceData())) {
            return;
        }
        BLonDevice[] a = this.makeDeviceList();
        for (int i = 0; i < a.length; ++i) {
            if (!this.isAnotherWithSameSubnet(sub, hash, a[i].getDeviceData())) continue;
            return;
        }
        BLonRouter[] r = this.makeRouterList();
        for (int i = 0; i < r.length; ++i) {
            if (this.isAnotherWithSameSubnet(sub, hash, r[i].getNearDeviceData())) {
                return;
            }
            if (!this.isAnotherWithSameSubnet(sub, hash, r[i].getFarDeviceData())) continue;
            return;
        }
        this.lon.log().fine("free subnet " + sub);
        this.subnetMap[sub] = 0;
        this.updateRouterManager = true;
    }

    private boolean isAnotherWithSameSubnet(int sub, int hash, BDeviceData dd) {
        if (dd.getLastHash() == hash) {
            return false;
        }
        return dd.getSubnetNodeId().getSubnetId() == sub;
    }

    private boolean isValidSubnet(int subnetId, int channelId) {
        int c = this.subnetMap[subnetId];
        return c == channelId || c == 0;
    }

    private int claimSubnetNodeId(BDeviceData dd) {
        int chanId = dd.getChannelId();
        int hash = this.findSubnetNode(chanId);
        BSubnetNode sn = BSubnetNode.make(NAddressManager.getSubnetFromHash(hash), NAddressManager.getNodeFromHash(hash));
        dd.set(BDeviceData.subnetNodeId, (BValue)sn, localChange);
        return hash;
    }

    private int findSubnetNode(int chanId) {
        int subnet = this.getNextSubnet(0, chanId);
        int nodeId = 1;
        while (this.deviceHash.get(NAddressManager.getDeviceHash(subnet, nodeId, chanId)) != null) {
            if (++nodeId < 127) continue;
            subnet = this.getNextSubnet(subnet, chanId);
            nodeId = 1;
        }
        return NAddressManager.getDeviceHash(subnet, nodeId, chanId);
    }

    private int getNextSubnet(int orig, int chanId) {
        for (int i = ++orig; i <= 255; ++i) {
            if (this.subnetMap[i] != chanId) continue;
            return i;
        }
        int firstFree = -1;
        for (int i = chanId; i <= 255; ++i) {
            if (this.subnetMap[i] != 0) continue;
            this.lon.log().fine("claim subnet " + i + " for channel " + chanId);
            this.subnetMap[i] = chanId;
            this.updateRouterManager = true;
            return i;
        }
        throw new RuntimeException("No more available subnets.");
    }

    public static int getDeviceHash(BLonDevice lonDevice) {
        return NAddressManager.getDeviceHash(lonDevice.getDeviceData());
    }

    private static int getDeviceHash(BDeviceData dd) {
        BSubnetNode sn = dd.getSubnetNodeId();
        return NAddressManager.getDeviceHash(sn.getSubnetId(), sn.getNodeId(), dd.getChannelId());
    }

    private static int getDeviceHash(int subnet, int node, int chanId) {
        return (chanId << 15) + (subnet << 7) + node;
    }

    public static int getSubnetFromHash(int hash) {
        return hash >> 7 & 0xFF;
    }

    public static int getNodeFromHash(int hash) {
        return hash & 0x7F;
    }

    public static int getChanIdFromHash(int hash) {
        return hash >> 15 & 0xFFFF;
    }

    public RouterManager routerManager() {
        if (this.routerManager == null) {
            this.routerManager = new RouterManager(this, this.lon);
        }
        if (this.updateRouterManager) {
            this.routerManager.update();
        }
        this.updateRouterManager = false;
        return this.routerManager;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startTable(true);
        out.trTitle((Object)"subnetMap", 2);
        out.w((Object)"<tr>").th((Object)"Subnet").th((Object)"Channel").w((Object)"</tr>\n");
        for (int i = 0; i < this.subnetMap.length; ++i) {
            if (this.subnetMap[i] == 0) continue;
            out.tr((Object)Integer.toString(i), (Object)Integer.toString(this.subnetMap[i]));
        }
        out.endTable();
        out.startProps("Misc");
        out.prop((Object)"updateRouterManager", this.updateRouterManager);
        out.prop((Object)"staleDeviceList", this.staleDeviceList);
        out.prop((Object)"staleRtrList", this.staleRtrList);
        out.prop((Object)"local", (Object)this.local.getName());
        out.endProps();
        out.startTable(true);
        out.trTitle((Object)"deviceHash", 4);
        out.w((Object)"<tr>").th((Object)"dev").th((Object)"chan").th((Object)"s/n").th((Object)"hash").w((Object)"</tr>\n");
        IntHashMap.Iterator it = this.deviceHash.iterator();
        while (it.hasNext()) {
            BComponent c = (BComponent)it.next();
            int h = it.key();
            out.tr((Object)c.getName(), (Object)Integer.toString(NAddressManager.getChanIdFromHash(h)), (Object)(Integer.toString(NAddressManager.getSubnetFromHash(h)) + "/" + Integer.toString(NAddressManager.getNodeFromHash(h))), (Object)Integer.toString(h, 16));
        }
        out.endTable();
        if (this.devList != null) {
            out.startProps("devList");
            for (int i = 0; i < this.devList.length; ++i) {
                if (this.devList[i] == null) continue;
                out.prop((Object)Integer.toString(i), (Object)this.devList[i].getName());
            }
            out.endProps();
        }
        if (this.rtrList != null) {
            out.startProps("rtrList");
            for (int i = 0; i < this.rtrList.length; ++i) {
                if (this.rtrList[i] == null) continue;
                out.prop((Object)Integer.toString(i), (Object)this.rtrList[i].getName());
            }
            out.endProps();
        }
        this.routerManager().spy(out);
    }
}

