/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.discover;

import com.tridium.lonworks.discover.BLonCreationEntry;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.BLonObjectFolder;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BIProtected;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.units.BUnit;

public final class LonLearnUtil {
    private static final Logger log = Logger.getLogger("lonworks");

    private LonLearnUtil() {
    }

    public static BLonCreationEntry[] discoverPointEntries(BComponent target, Context cx) {
        BLonDevice dev = (BLonDevice)CompUtil.closestAncestor((BComplex)target, BLonDevice.class).orElseThrow(NullPointerException::new);
        if (!dev.getPermissions(cx).hasOperatorRead()) {
            throw new UnresolvedException();
        }
        dev.getComponentSpace().update((BComponent)dev, Integer.MAX_VALUE);
        ArrayList<BLonCreationEntry> list = new ArrayList<BLonCreationEntry>();
        LonLearnUtil.doUpdateDiscoveryRows(list, (BComponent)dev, cx);
        return list.toArray(new BLonCreationEntry[0]);
    }

    public static void doUpdateDiscoveryRows(ArrayList<BLonCreationEntry> list, BComponent tgtCntr, Context cx) {
        SlotCursor c = tgtCntr.getProperties();
        while (c.nextObject()) {
            BLonCreationEntry objEntry;
            ArrayList<BLonCreationEntry> al;
            BValue value = tgtCntr.get(c.property());
            if (value instanceof BIProtected && !((BIProtected)value).getPermissions(cx).hasOperatorRead()) continue;
            if (c.property().getType().is(BLonComponent.TYPE)) {
                BLonCreationEntry e;
                BLonComponent lc = (BLonComponent)c.get();
                BLonData ldat = lc.getData();
                String target = lc.getDisplayName(cx);
                if (lc != ldat) {
                    target = target + "/" + ldat.getDisplayName(cx);
                }
                if ((e = LonLearnUtil.addElementRows(ldat, target, cx)) == null) {
                    log.severe("creation entry null");
                    continue;
                }
                list.add(e);
                continue;
            }
            if (c.property().getType().is(BLonObject.TYPE)) {
                BLonObject lo = (BLonObject)c.get();
                al = new ArrayList<BLonCreationEntry>();
                LonLearnUtil.doUpdateDiscoveryRows(al, lo, cx);
                objEntry = new BLonCreationEntry(lo);
                objEntry.setChildren(al.toArray(new BLonCreationEntry[0]));
                list.add(objEntry);
                continue;
            }
            if (!c.property().getType().is(BLonObjectFolder.TYPE)) continue;
            BLonObjectFolder lof = (BLonObjectFolder)c.get();
            al = new ArrayList();
            LonLearnUtil.doUpdateDiscoveryRows(al, (BComponent)lof, cx);
            objEntry = new BLonCreationEntry((BComponent)lof);
            objEntry.setChildren(al.toArray(new BLonCreationEntry[0]));
            list.add(objEntry);
        }
    }

    private static BLonCreationEntry addElementRows(BLonData ldat, String prefix, Context cx) {
        BLonCreationEntry firstEntry = null;
        ArrayList<BLonCreationEntry> list = null;
        SlotCursor c = ldat.getProperties();
        while (c.nextObject()) {
            Property p = c.property();
            BValue value = ldat.get(p);
            if (value instanceof BIProtected && !((BIProtected)value).getPermissions(cx).hasOperatorRead()) continue;
            BLonCreationEntry entry = null;
            if (p.getType().is(BLonPrimitive.TYPE)) {
                BFacets f = p.getFacets();
                BUnit devUnit = (BUnit)f.get("units");
                String unit = devUnit == null ? "" : devUnit.getSymbol();
                entry = new BLonCreationEntry(ldat, p.getName(), unit);
            } else if (p.getType().is(BLonData.TYPE)) {
                String pre = prefix + "/" + p.getDefaultDisplayName(cx);
                entry = LonLearnUtil.addElementRows((BLonData)c.get(), pre, cx);
            }
            if (entry == null) continue;
            if (firstEntry == null) {
                firstEntry = entry;
                continue;
            }
            if (list == null) {
                list = new ArrayList<BLonCreationEntry>();
            }
            list.add(entry);
        }
        if (list != null) {
            BLonCreationEntry[] rows = list.toArray(new BLonCreationEntry[0]);
            firstEntry.setChildren(rows);
        }
        return firstEntry;
    }
}

